/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class SonarParticle
extends SimpleAnimatedParticle {
    private final float rot;
    private final float pitch;

    protected SonarParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, SpriteSet spriteSet) {
        super(clientLevel, x, y, z, spriteSet, 0.0f);
        this.friction = 1.0f;
        this.xd = dx;
        this.yd = dy;
        this.zd = dz;
        this.quadSize = this.random.nextFloat() * this.random.nextFloat() * 2.0f + 2.0f;
        this.lifetime = (int)(100.0f + this.random.nextFloat());
        this.rot = (float)Mth.atan2((double)(-dx), (double)(-dz));
        this.pitch = (float)Mth.atan2((double)(-dy), (double)Math.sqrt(dx * dx + dz * dz));
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        super.tick();
        if (this.onGround || this.xd == 0.0 || this.zd == 0.0) {
            this.remove();
        }
        this.alpha = 1.0f - (float)this.age / (float)this.lifetime;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) * 1.5f / (float)this.lifetime), (float)0.0f, (float)1.0f) * 0.75f;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateY(this.rot).rotateX(-this.pitch);
        this.renderRotatedQuad(vertexConsumer, camera, quaternionf, partialTicks);
        quaternionf = new Quaternionf();
        quaternionf.rotateY((float)(-Math.PI) + this.rot).rotateX(this.pitch);
        this.renderRotatedQuad(vertexConsumer, camera, quaternionf, partialTicks);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new SonarParticle(level, x, y, z, dx, dy, dz, this.sprites);
        }
    }
}

