/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ShockwaveParticle
extends SimpleAnimatedParticle {
    private final float rot;
    private final float pitch;

    protected ShockwaveParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, SpriteSet spriteSet) {
        super(clientLevel, x, y, z, spriteSet, 0.0f);
        this.friction = 1.0f;
        this.xd = dx;
        this.yd = dy;
        this.zd = dz;
        this.quadSize = this.random.nextFloat() * this.random.nextFloat() * 1.0f + 1.0f;
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
        this.rot = (float)Mth.atan2((double)(-dx), (double)(-dz));
        this.pitch = (float)Mth.atan2((double)(-dy), (double)Math.sqrt(dx * dx + dz * dz));
        this.setFadeColor(15916745);
        this.setSpriteFromAge(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
        if (this.onGround || this.xd == 0.0 || this.zd == 0.0) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateY(this.rot).rotateX(-(this.pitch + 1.5707964f));
        this.renderRotatedQuad(vertexConsumer, camera, quaternionf, partialTicks);
        quaternionf = new Quaternionf();
        quaternionf.rotateY((float)(-Math.PI) + this.rot).rotateX(this.pitch + 1.5707964f);
        this.renderRotatedQuad(vertexConsumer, camera, quaternionf, partialTicks);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ShockwaveParticle(level, x, y, z, dx, dy, dz, this.sprites);
        }
    }
}

