/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.client.renderer.effect.BoltEffect;
import cn.leolezury.eternalstarlight.common.client.renderer.effect.BoltRenderer;
import cn.leolezury.eternalstarlight.common.particle.LightningParticleOptions;
import cn.leolezury.eternalstarlight.common.util.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class LightningParticle
extends Particle {
    private final Vec3 endPos;
    private final Vector3f color;
    private final BoltRenderer boltRenderer = new BoltRenderer();

    protected LightningParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Vector3f color) {
        super(level, x, y, z);
        this.endPos = new Vec3(xSpeed, ySpeed, zSpeed);
        this.color = color;
        this.gravity = 0.0f;
        this.lifetime = 5 + new Random().nextInt(3);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.getPosition();
        PoseStack stack = new PoseStack();
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x);
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y);
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z);
        stack.pushPose();
        stack.translate(x, y, z);
        stack.scale(1.5f, 1.5f, 1.5f);
        float progress = ((float)this.age + partialTick) / (float)this.lifetime;
        BoltEffect.BoltRenderInfo lightningBoltData = new BoltEffect.BoltRenderInfo().color(Color.rgbad(this.color.x, this.color.y, this.color.z, 1.0f - progress)).noise(0.2f, 0.2f).branching(0.3f, 0.6f).spreader(BoltEffect.SegmentSpreader.memory(0.9f));
        BoltEffect bolt = new BoltEffect(lightningBoltData, Vec3.ZERO, this.endPos, 4).size(0.05f).lifespan(this.lifetime).spawn(BoltEffect.SpawnFunction.CONSECUTIVE);
        this.boltRenderer.update((Object)this, bolt, partialTick);
        this.boltRenderer.render(partialTick, stack, (MultiBufferSource)source);
        source.endBatch();
        stack.popPose();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Provider
    implements ParticleProvider<LightningParticleOptions> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(LightningParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LightningParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.getColor());
        }
    }
}

