/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.LunarMonstrosityAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LunarMonstrosityModel<T extends LunarMonstrosity>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("lunar_monstrosity"), "main");
    private final ModelPart root;
    public final ModelPart stemAll;
    public final ModelPart stemMiddle;
    public final ModelPart stemTop;
    public final ModelPart head;
    private final ModelPart eye;

    public LunarMonstrosityModel(ModelPart root) {
        this.root = root.getChild("root");
        this.stemAll = root.getChild("root").getChild("stem_all");
        this.stemMiddle = root.getChild("root").getChild("stem_all").getChild("stem_middle");
        this.stemTop = root.getChild("root").getChild("stem_all").getChild("stem_middle").getChild("stem_top");
        this.head = root.getChild("root").getChild("stem_all").getChild("stem_middle").getChild("stem_top").getChild("head");
        this.eye = root.getChild("root").getChild("stem_all").getChild("stem_middle").getChild("stem_top").getChild("head").getChild("eye");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition stem_all = root.addOrReplaceChild("stem_all", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -20.0f, -2.5f, 5.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition stem_middle = stem_all.addOrReplaceChild("stem_middle", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -20.0f, -2.5f, 5.0f, 20.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-20.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition stem_top = stem_middle.addOrReplaceChild("stem_top", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -20.0f, -2.5f, 5.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-20.0f, (float)0.0f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition head = stem_top.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-20.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("petal_down", CubeListBuilder.create().texOffs(20, 0).addBox(-5.0f, 1.0f, -20.0f, 10.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("petal_right", CubeListBuilder.create().texOffs(-10, 55).addBox(-0.3f, 1.0f, -5.0f, 20.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        head.addOrReplaceChild("petal_left", CubeListBuilder.create().texOffs(-10, 45).addBox(-20.0f, 0.0f, -5.0f, 20.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        head.addOrReplaceChild("petal_up", CubeListBuilder.create().texOffs(20, 20).addBox(-5.0f, 1.0f, 0.0f, 10.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)5.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("upper_jaw", CubeListBuilder.create().texOffs(61, 0).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("lower_jaw", CubeListBuilder.create().texOffs(60, 15).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("soul", CubeListBuilder.create().texOffs(52, 30).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leaf1 = root.addOrReplaceChild("leaf1", CubeListBuilder.create().texOffs(-8, 75).addBox(-16.0f, 0.0f, -4.0f, 16.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.6981f, (float)1.5708f));
        leaf1.addOrReplaceChild("leaf_outside1", CubeListBuilder.create().texOffs(-10, 65).addBox(-19.0f, 0.0f, -5.0f, 19.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition leaf2_rotated = root.addOrReplaceChild("leaf2_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.2566f, (float)0.0f));
        PartDefinition leaf2 = leaf2_rotated.addOrReplaceChild("leaf2", CubeListBuilder.create().texOffs(-8, 75).addBox(-16.0f, 0.0f, -4.0f, 16.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.6981f, (float)1.5708f));
        leaf2.addOrReplaceChild("leaf_outside2", CubeListBuilder.create().texOffs(-10, 65).addBox(-19.0f, 0.0f, -5.0f, 19.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition leaf3_rotated = root.addOrReplaceChild("leaf3_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.5133f, (float)0.0f));
        PartDefinition leaf3 = leaf3_rotated.addOrReplaceChild("leaf3", CubeListBuilder.create().texOffs(-8, 75).addBox(-16.0f, 0.0f, -4.0f, 16.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.6981f, (float)1.5708f));
        leaf3.addOrReplaceChild("leaf_outside3", CubeListBuilder.create().texOffs(-10, 65).addBox(-19.0f, 0.0f, -5.0f, 19.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition leaf4_rotated = root.addOrReplaceChild("leaf4_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.5133f, (float)0.0f));
        PartDefinition leaf4 = leaf4_rotated.addOrReplaceChild("leaf4", CubeListBuilder.create().texOffs(-8, 75).addBox(-16.0f, 0.0f, -4.0f, 16.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.6981f, (float)1.5708f));
        leaf4.addOrReplaceChild("leaf_outside4", CubeListBuilder.create().texOffs(-10, 65).addBox(-19.0f, 0.0f, -5.0f, 19.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition leaf5_rotated = root.addOrReplaceChild("leaf5_rotated", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2566f, (float)0.0f));
        PartDefinition leaf5 = leaf5_rotated.addOrReplaceChild("leaf5", CubeListBuilder.create().texOffs(-8, 75).addBox(-16.0f, 0.0f, -4.0f, 16.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.6981f, (float)1.5708f));
        leaf5.addOrReplaceChild("leaf_outside5", CubeListBuilder.create().texOffs(-10, 65).addBox(-19.0f, 0.0f, -5.0f, 19.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        boolean bl = this.eye.visible = ((ESBoss)entity).getPhase() == 0;
        if (((ESBoss)entity).getBehaviorState() != 0 && ((LunarMonstrosity)entity).deathTime <= 0) {
            int state = ((ESBoss)entity).getBehaviorState();
            switch (state) {
                case 1: {
                    this.animate(((LunarMonstrosity)entity).toxicBreathAnimationState, LunarMonstrosityAnimation.TOXIC_BREATH, ageInTicks);
                    break;
                }
                case 2: {
                    this.animate(((LunarMonstrosity)entity).sporeAnimationState, LunarMonstrosityAnimation.SPORE, ageInTicks);
                    break;
                }
                case 3: {
                    this.animate(((LunarMonstrosity)entity).thornAnimationState, LunarMonstrosityAnimation.THORN, ageInTicks);
                    break;
                }
                case 4: {
                    this.animate(((LunarMonstrosity)entity).biteAnimationState, LunarMonstrosityAnimation.BITE, ageInTicks);
                    break;
                }
                case 5: {
                    this.animate(((LunarMonstrosity)entity).digAnimationState, LunarMonstrosityAnimation.DIG, ageInTicks);
                    break;
                }
                case 6: {
                    this.animate(((LunarMonstrosity)entity).sneakAnimationState, LunarMonstrosityAnimation.SNEAK, ageInTicks);
                    break;
                }
                case 7: {
                    this.animate(((LunarMonstrosity)entity).emergeAnimationState, LunarMonstrosityAnimation.EMERGE, ageInTicks);
                    break;
                }
                case 8: {
                    this.animate(((LunarMonstrosity)entity).switchPhaseAnimationState, LunarMonstrosityAnimation.SWITCH_PHASE, ageInTicks);
                }
            }
        }
        if (((LunarMonstrosity)entity).deathTime > 0) {
            this.animate(((LunarMonstrosity)entity).deathAnimationState, LunarMonstrosityAnimation.DEATH, ageInTicks);
        }
    }

    public RenderType renderType(ResourceLocation resourceLocation) {
        return RenderType.entityTranslucent((ResourceLocation)resourceLocation);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

