/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.projectile.FrozenTube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FrozenTubeModel<T extends FrozenTube>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("frozen_tube"), "main");
    private final ModelPart rod;

    public FrozenTubeModel(ModelPart root) {
        this.rod = root.getChild("rod");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("rod", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -4.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 16).addBox(-1.0f, -4.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)23.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rod.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rod.xRot = headPitch * ((float)Math.PI / 180);
    }

    public RenderType renderType(ResourceLocation resourceLocation) {
        return RenderType.entityTranslucent((ResourceLocation)resourceLocation);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rod.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

