/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.AethersentGolemAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.AethersentGolem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AethersentGolemModel<T extends AethersentGolem>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("aethersent_golem"), "main");
    private final ModelPart root;
    public final ModelPart upper;
    public final ModelPart body;
    public final ModelPart leftArm;
    public final ModelPart leftMuzzle;
    public final ModelPart rightArm;
    public final ModelPart rightMuzzle;
    private final ModelPart head;
    private final ModelPart eye;
    private final ModelPart lower;

    public AethersentGolemModel(ModelPart root) {
        this.root = root;
        this.upper = root.getChild("upper");
        this.body = this.upper.getChild("body");
        this.leftArm = this.body.getChild("left_arm");
        this.leftMuzzle = this.leftArm.getChild("left_muzzle");
        this.rightArm = this.body.getChild("right_arm");
        this.rightMuzzle = this.rightArm.getChild("right_muzzle");
        this.head = this.upper.getChild("head");
        this.eye = this.head.getChild("eye");
        this.lower = root.getChild("lower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper = partdefinition.addOrReplaceChild("upper", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition body = upper.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -10.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 22).addBox(-5.0f, -8.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 22).mirror().addBox(3.0f, -8.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 16).mirror().addBox(0.0f, -4.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)-7.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_muzzle", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)8.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(32, 16).addBox(-6.0f, -4.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-7.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_muzzle", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)8.0f, (float)0.0f));
        PartDefinition head = upper.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-18.0f, (float)0.0f));
        head.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.25f, (float)-4.05f));
        PartDefinition antenna = head.addOrReplaceChild("antenna", CubeListBuilder.create().texOffs(32, 4).addBox(-2.0f, -2.5f, -1.5f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-3.5f, (float)-0.5f));
        antenna.addOrReplaceChild("upper_antenna", CubeListBuilder.create().texOffs(44, 7).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-2.5f, (float)0.5f));
        partdefinition.addOrReplaceChild("lower", CubeListBuilder.create().texOffs(0, 44).addBox(-7.0f, -3.0f, -7.0f, 14.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-2.0f, -11.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Entity camera;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.animate(((AethersentGolem)((Object)entity)).shootAnimationState, AethersentGolemAnimation.SHOOT, ageInTicks);
        this.animate(((AethersentGolem)((Object)entity)).shootAnimationState, AethersentGolemAnimation.ANTENNA_DETECTED, ageInTicks);
        this.animate(((AethersentGolem)((Object)entity)).shootEndAnimationState, AethersentGolemAnimation.SHOOT_END, ageInTicks);
        this.leftArm.xRot += headPitch * ((float)Math.PI / 180);
        this.rightArm.xRot += headPitch * ((float)Math.PI / 180);
        if (((AethersentGolem)((Object)entity)).useLeftHand) {
            this.rightArm.resetPose();
        } else {
            this.leftArm.resetPose();
        }
        this.lower.yRot = -Mth.rotLerp((float)Mth.frac((float)ageInTicks), (float)((AethersentGolem)((Object)entity)).yBodyRotO, (float)((AethersentGolem)((Object)entity)).yBodyRot) * ((float)Math.PI / 180);
        if (!((AethersentGolem)((Object)entity)).shootAnimationState.isStarted() && (camera = Minecraft.getInstance().getCameraEntity()) != null) {
            Vec3 targetEyePos = camera.getEyePosition(0.0f);
            Vec3 golemEyePos = entity.getEyePosition(0.0f);
            this.eye.y = targetEyePos.y > golemEyePos.y ? (this.eye.y += -0.6f) : (this.eye.y += 0.0f);
            Vec3 vec33 = entity.getViewVector(0.0f);
            vec33 = new Vec3(vec33.x, 0.0, vec33.z);
            Vec3 vec34 = new Vec3(golemEyePos.x - targetEyePos.x, 0.0, golemEyePos.z - targetEyePos.z).normalize().yRot(1.5707964f);
            double e = vec33.dot(vec34);
            this.eye.x += Mth.sqrt((float)((float)Math.abs(e))) * 2.0f * (float)Math.signum(e);
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

