/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public interface Stellagmite {
    public static final Supplier<ImmutableMap<Block, Block>> TO_MOLTEN = Suppliers.memoize(() -> ImmutableMap.of((Object)ESBlocks.STELLAGMITE.get(), (Object)ESBlocks.MOLTEN_STELLAGMITE.get(), (Object)((Block)ESBlocks.STELLAGMITE_SLAB.get()), (Object)((Block)ESBlocks.MOLTEN_STELLAGMITE_SLAB.get()), (Object)((Block)ESBlocks.STELLAGMITE_STAIRS.get()), (Object)((Block)ESBlocks.MOLTEN_STELLAGMITE_STAIRS.get()), (Object)((Block)ESBlocks.STELLAGMITE_WALL.get()), (Object)((Block)ESBlocks.MOLTEN_STELLAGMITE_WALL.get())));

    @Nullable
    default public BlockState getPlacementState(BlockPlaceContext context, BlockState state) {
        return state == null ? null : (this.isAffectedByFluid(state, (LevelAccessor)context.getLevel(), context.getClickedPos(), (TagKey<Fluid>)FluidTags.LAVA) ? this.asMolten(state) : (this.isAffectedByFluid(state, (LevelAccessor)context.getLevel(), context.getClickedPos(), (TagKey<Fluid>)FluidTags.WATER) ? this.asCooled(state) : state));
    }

    default public ItemInteractionResult use(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand) {
        Block block = blockState.getBlock();
        ImmutableMap<Block, Block> toMolten = TO_MOLTEN.get();
        if (toMolten.containsKey((Object)block) && itemStack.is(ESTags.Items.STELLAGMITE_IGNITERS) && (this.isAffectedByFluid(blockState, (LevelAccessor)level, blockPos, (TagKey<Fluid>)FluidTags.LAVA) || !this.isAffectedByFluid(blockState, (LevelAccessor)level, blockPos, (TagKey<Fluid>)FluidTags.WATER))) {
            SoundEvent soundEvent = itemStack.isDamageableItem() ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE;
            level.playSound(player, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), soundEvent, player.getSoundSource(), 1.0f, player.getRandom().nextFloat() * 0.4f + 0.8f);
            if (!itemStack.isDamageableItem()) {
                itemStack.consume(1, (LivingEntity)player);
            } else {
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            }
            Block moltenBlock = (Block)toMolten.get((Object)block);
            if (moltenBlock != null) {
                level.setBlockAndUpdate(blockPos, moltenBlock.withPropertiesOf(blockState));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public BlockState updateShape(BlockState state, LevelAccessor level, BlockPos pos) {
        return this.isAffectedByFluid(state, level, pos, (TagKey<Fluid>)FluidTags.LAVA) ? this.asMolten(state) : (this.isAffectedByFluid(state, level, pos, (TagKey<Fluid>)FluidTags.WATER) ? this.asCooled(state) : state);
    }

    default public void step(Entity entity) {
        Stellagmite stellagmite = this;
        if (stellagmite instanceof Block) {
            Block block = (Block)stellagmite;
            if (TO_MOLTEN.get().containsValue((Object)block) && !entity.isSteppingCarefully() && entity instanceof LivingEntity) {
                entity.hurt(entity.level().damageSources().hotFloor(), 1.0f);
            }
        }
    }

    default public boolean isAffectedByFluid(BlockState state, LevelAccessor level, BlockPos pos, TagKey<Fluid> fluid) {
        return Arrays.stream(Direction.values()).anyMatch(direction -> level.getFluidState(pos.relative(direction)).is(fluid)) || state.getFluidState().is(fluid);
    }

    default public BlockState asMolten(BlockState state) {
        Block molten = (Block)TO_MOLTEN.get().get((Object)state.getBlock());
        return molten != null ? molten.withPropertiesOf(state) : state;
    }

    default public BlockState asCooled(BlockState state) {
        Optional<Block> cooled = TO_MOLTEN.get().entrySet().stream().filter(e -> e.getValue() == state.getBlock()).findFirst().map(Map.Entry::getKey);
        return cooled.map(block -> block.withPropertiesOf(state)).orElse(state);
    }
}

