/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.HorizontalAxisBlock;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RedstoneDoomedenKeyholeBlock
extends HorizontalAxisBlock {
    public static final MapCodec<RedstoneDoomedenKeyholeBlock> CODEC = RedstoneDoomedenKeyholeBlock.simpleCodec(RedstoneDoomedenKeyholeBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public RedstoneDoomedenKeyholeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.X));
    }

    protected MapCodec<RedstoneDoomedenKeyholeBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)blockPlaceContext.getHorizontalDirection().getAxis());
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean lit = (Boolean)state.getValue((Property)LIT);
        if (!lit && Arrays.stream(Direction.values()).filter(direction -> direction.getAxis() == state.getValue((Property)AXIS)).anyMatch(direction -> this.hasInputSignal(level, pos, (Direction)direction))) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
        }
        if (lit && Arrays.stream(Direction.values()).filter(direction -> direction.getAxis() == state.getValue((Property)AXIS)).noneMatch(direction -> this.hasInputSignal(level, pos, (Direction)direction))) {
            level.scheduleTick(pos, (Block)this, 4);
        }
    }

    protected boolean hasInputSignal(Level level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        int i = level.getSignal(blockPos, direction);
        if (i >= 15) {
            return true;
        }
        BlockState blockState = level.getBlockState(blockPos);
        return Math.max(i, blockState.is(Blocks.REDSTONE_WIRE) ? (Integer)blockState.getValue((Property)RedStoneWireBlock.POWER) : 0) > 0;
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue() && Arrays.stream(Direction.values()).filter(direction -> direction.getAxis() == blockState.getValue((Property)AXIS)).noneMatch(direction -> this.hasInputSignal((Level)serverLevel, blockPos, (Direction)direction))) {
            serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isSignalSource(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LIT);
    }

    public int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return (Boolean)blockState.getValue((Property)LIT) != false && direction.getAxis() != blockState.getValue((Property)AXIS) ? 15 : super.getSignal(blockState, blockGetter, blockPos, direction);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
        super.createBlockStateDefinition(builder);
    }
}

