/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.ESShortBushBlock;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class MoonlightBushBlock
extends ESShortBushBlock
implements BonemealableBlock {
    public static final MapCodec<MoonlightBushBlock> CODEC = MoonlightBushBlock.simpleCodec(MoonlightBushBlock::new);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public MoonlightBushBlock(BlockBehaviour.Properties properties) {
        super(11, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<MoonlightBushBlock> codec() {
        return CODEC;
    }

    protected void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        boolean berries = (Boolean)blockState.getValue((Property)BERRIES);
        if (!berries && randomSource.nextInt(15) == 0 && serverLevel.getRawBrightness(blockPos.above(), 0) >= 9) {
            BlockState state = (BlockState)blockState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true));
            serverLevel.setBlockAndUpdate(blockPos, state);
            serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)state));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        boolean berries = (Boolean)blockState.getValue((Property)BERRIES);
        return !berries && itemStack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        boolean berries = (Boolean)blockState.getValue((Property)BERRIES);
        if (berries) {
            MoonlightBushBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)ESItems.LUNAR_BERRIES.get().getDefaultInstance());
            BlockState state = (BlockState)blockState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlockAndUpdate(blockPos, state);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)state));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(4) == 0) {
            ParticleUtils.spawnParticleInBlock((LevelAccessor)level, (BlockPos)pos, (int)random.nextInt(1, 4), (ParticleOptions)(random.nextInt(4) == 0 ? (ParticleOptions)ESParticles.FIREFLY.get() : (ParticleOptions)ESParticles.STARDUST.get()));
        }
    }
}

