/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.entity.living.AethersentGolem;
import cn.leolezury.eternalstarlight.common.entity.living.GrimstoneGolem;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CarvedLunarisCactusFruitBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<CarvedLunarisCactusFruitBlock> CODEC = CarvedLunarisCactusFruitBlock.simpleCodec(CarvedLunarisCactusFruitBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    @Nullable
    private BlockPattern snowGolemBase;
    @Nullable
    private BlockPattern snowGolemFull;
    @Nullable
    private BlockPattern ironGolemBase;
    @Nullable
    private BlockPattern ironGolemFull;
    @Nullable
    private BlockPattern grimstoneGolemBase;
    @Nullable
    private BlockPattern grimstoneGolemFull;
    @Nullable
    private BlockPattern aethersentGolemBase;
    @Nullable
    private BlockPattern aethersentGolemFull;
    private static final Predicate<BlockState> LUNARIS_CACTUS_FRUIT_PREDICATE = state -> state != null && (state.is((Block)ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get()) || state.is((Block)ESBlocks.LUNARIS_CACTUS_FRUIT_LANTERN.get()));

    public CarvedLunarisCactusFruitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<? extends CarvedLunarisCactusFruitBlock> codec() {
        return CODEC;
    }

    protected void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.onPlace(blockState, level, blockPos, blockState2, bl);
        if (!blockState2.is(blockState.getBlock())) {
            this.trySpawnGolem(level, blockPos);
        }
    }

    public boolean canSpawnGolem(LevelReader levelReader, BlockPos blockPos) {
        return this.getOrCreateSnowGolemBase().find(levelReader, blockPos) != null || this.getOrCreateIronGolemBase().find(levelReader, blockPos) != null || this.getOrCreateGrimstoneGolemBase().find(levelReader, blockPos) != null || this.getOrCreateAethersentGolemBase().find(levelReader, blockPos) != null;
    }

    private void trySpawnGolem(Level level, BlockPos blockPos) {
        AethersentGolem aethersentGolem;
        BlockPattern.BlockPatternMatch snowGolemMatch = this.getOrCreateSnowGolemFull().find((LevelReader)level, blockPos);
        BlockPattern.BlockPatternMatch ironGolemMatch = this.getOrCreateIronGolemFull().find((LevelReader)level, blockPos);
        BlockPattern.BlockPatternMatch grimstoneGolemMatch = this.getOrCreateGrimstoneGolemFull().find((LevelReader)level, blockPos);
        BlockPattern.BlockPatternMatch aethersentGolemMatch = this.getOrCreateAethersentGolemFull().find((LevelReader)level, blockPos);
        if (snowGolemMatch != null) {
            SnowGolem snowGolem = (SnowGolem)EntityType.SNOW_GOLEM.create(level);
            if (snowGolem != null) {
                CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, snowGolemMatch, (Entity)snowGolem, snowGolemMatch.getBlock(0, 2, 0).getPos());
            }
        } else if (ironGolemMatch != null) {
            IronGolem ironGolem = (IronGolem)EntityType.IRON_GOLEM.create(level);
            if (ironGolem != null) {
                ironGolem.setPlayerCreated(true);
                CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, ironGolemMatch, (Entity)ironGolem, ironGolemMatch.getBlock(1, 2, 0).getPos());
            }
        } else if (grimstoneGolemMatch != null) {
            GrimstoneGolem grimstoneGolem = (GrimstoneGolem)ESEntities.GRIMSTONE_GOLEM.get().create(level);
            if (grimstoneGolem != null) {
                CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, grimstoneGolemMatch, (Entity)grimstoneGolem, grimstoneGolemMatch.getBlock(0, 1, 0).getPos());
            }
        } else if (aethersentGolemMatch != null && (aethersentGolem = (AethersentGolem)ESEntities.AETHERSENT_GOLEM.get().create(level)) != null) {
            CarvedLunarisCactusFruitBlock.spawnGolemInWorld(level, aethersentGolemMatch, (Entity)aethersentGolem, aethersentGolemMatch.getBlock(0, 1, 0).getPos());
        }
    }

    private static void spawnGolemInWorld(Level level, BlockPattern.BlockPatternMatch blockPatternMatch, Entity entity, BlockPos blockPos) {
        CarvedLunarisCactusFruitBlock.clearPatternBlocks(level, blockPatternMatch);
        entity.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.05, (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity(entity);
        for (ServerPlayer serverPlayer : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, entity);
        }
        CarvedLunarisCactusFruitBlock.updatePatternBlocks(level, blockPatternMatch);
    }

    public static void clearPatternBlocks(Level level, BlockPattern.BlockPatternMatch blockPatternMatch) {
        for (int i = 0; i < blockPatternMatch.getWidth(); ++i) {
            for (int j = 0; j < blockPatternMatch.getHeight(); ++j) {
                BlockInWorld blockInWorld = blockPatternMatch.getBlock(i, j, 0);
                level.setBlock(blockInWorld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                level.levelEvent(2001, blockInWorld.getPos(), Block.getId((BlockState)blockInWorld.getState()));
            }
        }
    }

    public static void updatePatternBlocks(Level level, BlockPattern.BlockPatternMatch blockPatternMatch) {
        for (int i = 0; i < blockPatternMatch.getWidth(); ++i) {
            for (int j = 0; j < blockPatternMatch.getHeight(); ++j) {
                BlockInWorld blockInWorld = blockPatternMatch.getBlock(i, j, 0);
                level.blockUpdated(blockInWorld.getPos(), Blocks.AIR);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    private BlockPattern getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = BlockPatternBuilder.start().aisle(new String[]{" ", "#", "#"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemBase;
    }

    private BlockPattern getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = BlockPatternBuilder.start().aisle(new String[]{"^", "#", "#"}).where('^', BlockInWorld.hasState(LUNARIS_CACTUS_FRUIT_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemFull;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.start().aisle(new String[]{"~ ~", "###", "~#~"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('~', blockInWorld -> blockInWorld.getState().isAir()).build();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState(LUNARIS_CACTUS_FRUIT_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('~', blockInWorld -> blockInWorld.getState().isAir()).build();
        }
        return this.ironGolemFull;
    }

    private BlockPattern getOrCreateGrimstoneGolemBase() {
        if (this.grimstoneGolemBase == null) {
            this.grimstoneGolemBase = BlockPatternBuilder.start().aisle(new String[]{" ", "#"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)ESBlocks.GRIMSTONE_BRICKS.get()))).build();
        }
        return this.grimstoneGolemBase;
    }

    private BlockPattern getOrCreateGrimstoneGolemFull() {
        if (this.grimstoneGolemFull == null) {
            this.grimstoneGolemFull = BlockPatternBuilder.start().aisle(new String[]{"^", "#"}).where('^', BlockInWorld.hasState(LUNARIS_CACTUS_FRUIT_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)ESBlocks.GRIMSTONE_BRICKS.get()))).build();
        }
        return this.grimstoneGolemFull;
    }

    private BlockPattern getOrCreateAethersentGolemBase() {
        if (this.aethersentGolemBase == null) {
            this.aethersentGolemBase = BlockPatternBuilder.start().aisle(new String[]{" ", "#"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)ESBlocks.AETHERSENT_BLOCK.get()))).build();
        }
        return this.aethersentGolemBase;
    }

    private BlockPattern getOrCreateAethersentGolemFull() {
        if (this.aethersentGolemFull == null) {
            this.aethersentGolemFull = BlockPatternBuilder.start().aisle(new String[]{"^", "#"}).where('^', BlockInWorld.hasState(LUNARIS_CACTUS_FRUIT_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)ESBlocks.AETHERSENT_BLOCK.get()))).build();
        }
        return this.aethersentGolemFull;
    }
}

