/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntangledBinderItem
extends BaseItem {
    public static final DataComponentType<BinderTarget> BINDER_TARGET = DataComponentType.builder().persistent(RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(BinderTarget::dimension), (App)BlockPos.CODEC.fieldOf("pos").forGetter(BinderTarget::pos), (App)BlockState.CODEC.optionalFieldOf("state").forGetter(BinderTarget::state)).apply((Applicative)instance, BinderTarget::new))).networkSynchronized(StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BinderTarget::dimension, (StreamCodec)BlockPos.STREAM_CODEC, BinderTarget::pos, (StreamCodec)ByteBufCodecs.INT, t -> t.state().map(Block::getId).orElse(-1), (dim, pos, id) -> new BinderTarget((ResourceLocation)dim, (BlockPos)pos, id >= 0 ? Optional.ofNullable((BlockState)Block.BLOCK_STATE_REGISTRY.byId(id.intValue())) : Optional.empty()))).build();

    public static boolean isBound(ItemStack stack) {
        return stack.has(BINDER_TARGET);
    }

    public static BlockPos getBoundPosition(ItemStack stack) {
        return ((BinderTarget)stack.get(EntangledBinderItem.BINDER_TARGET)).pos;
    }

    public static ResourceLocation getBoundDimension(ItemStack stack) {
        return ((BinderTarget)stack.get(EntangledBinderItem.BINDER_TARGET)).dimension;
    }

    public EntangledBinderItem() {
        super(ItemProperties.create().maxStackSize(1).group(CreativeItemGroup.getToolsAndUtilities()));
    }

    public BaseItem.InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        BinderTarget target = (BinderTarget)stack.get(BINDER_TARGET);
        if (target != null && target.dimension.equals((Object)level.dimension().location()) && target.pos.equals((Object)hitPos)) {
            return BaseItem.InteractionFeedback.CONSUME;
        }
        if (!level.isClientSide) {
            stack.set(BINDER_TARGET, (Object)new BinderTarget(level.dimension().location(), hitPos, Optional.of(level.getBlockState(hitPos))));
            player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_binder.select").color(ChatFormatting.YELLOW).get(), true);
        }
        return BaseItem.InteractionFeedback.SUCCESS;
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (player.isCrouching() && stack.has(BINDER_TARGET)) {
            if (!level.isClientSide) {
                stack.remove(BINDER_TARGET);
                player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_binder.clear").color(ChatFormatting.YELLOW).get(), true);
            }
            return BaseItem.ItemUseResult.consume((ItemStack)stack);
        }
        return super.interact(stack, player, hand, level);
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info").color(ChatFormatting.AQUA).get());
        BinderTarget target = (BinderTarget)stack.get(BINDER_TARGET);
        if (target != null) {
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)target.dimension)).color(ChatFormatting.GOLD).get();
            MutableComponent xText = TextComponents.number((int)target.pos.getX()).color(ChatFormatting.GOLD).get();
            MutableComponent yText = TextComponents.number((int)target.pos.getY()).color(ChatFormatting.GOLD).get();
            MutableComponent zText = TextComponents.number((int)target.pos.getZ()).color(ChatFormatting.GOLD).get();
            if (target.state.isPresent()) {
                MutableComponent name = TextComponents.blockState((BlockState)target.state.get()).color(ChatFormatting.GOLD).get();
                info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info.target.known", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
            } else {
                info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info.target.unknown", (Object[])new Object[]{xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
            }
        }
    }

    public record BinderTarget(ResourceLocation dimension, BlockPos pos, Optional<BlockState> state) {
    }
}

