/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.client.ClientTapeCache;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateTapeTypeCountPacket(UUID tapeId, int typeCount, long byteCount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateTapeTypeCountPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"update_tape_type_count"));
    public static final StreamCodec<FriendlyByteBuf, UpdateTapeTypeCountPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, packet -> packet.tapeId().toString(), (StreamCodec)ByteBufCodecs.VAR_INT, UpdateTapeTypeCountPacket::typeCount, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateTapeTypeCountPacket::byteCount, (uuidStr, typeCount, byteCount) -> new UpdateTapeTypeCountPacket(UUID.fromString(uuidStr), (int)typeCount, (long)byteCount));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateTapeTypeCountPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientTapeCache.put(packet.tapeId(), packet.typeCount(), packet.byteCount()));
    }
}

