/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.datagen.assets;

import com.sts15.enderdrives.items.ItemInit;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class EDItemModelProvider
extends ItemModelProvider {
    public EDItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "enderdrives", existingFileHelper);
    }

    protected void registerModels() {
        this.enderDiskColors(ItemInit.ENDER_DISK_1K);
        this.enderDiskColors(ItemInit.ENDER_DISK_4K);
        this.enderDiskColors(ItemInit.ENDER_DISK_16K);
        this.enderDiskColors(ItemInit.ENDER_DISK_64K);
        this.enderDiskColors(ItemInit.ENDER_DISK_256K);
        this.enderDiskColors(ItemInit.ENDER_DISK_creative);
        this.enderDiskColors(ItemInit.TAPE_DISK);
        this.generated(ItemInit.ENDER_STORAGE_COMPONENT_1K);
        this.generated(ItemInit.ENDER_STORAGE_COMPONENT_4K);
        this.generated(ItemInit.ENDER_STORAGE_COMPONENT_16K);
        this.generated(ItemInit.ENDER_STORAGE_COMPONENT_64K);
        this.generated(ItemInit.ENDER_STORAGE_COMPONENT_256K);
    }

    private void generated(DeferredHolder<Item, ? extends Item> item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc(String.format("item/%s", item.getId().getPath())));
    }

    private void enderDiskColors(DeferredHolder<Item, ? extends Item> disk) {
        ArrayList<ModelBuilder> colors = new ArrayList<ModelBuilder>();
        ResourceLocation status = ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"status");
        for (String color : Arrays.asList("green", "blue", "yellow", "red")) {
            colors.add(((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.format("%s_%s", disk.getId().getPath(), color))).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc(String.format("item/%s", disk.getId().getPath())))).texture("layer1", this.modLoc(String.format("item/ender_disk_led_%s", color))));
        }
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(disk.getId().getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc(String.format("item/%s", disk.getId().getPath())))).texture("layer1", this.modLoc("item/ender_disk_led_green"))).override().predicate(status, 1.0f).model((ModelFile)colors.get(1)).end().override().predicate(status, 2.0f).model((ModelFile)colors.get(2)).end().override().predicate(status, 3.0f).model((ModelFile)colors.get(3)).end();
    }
}

