/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.datagen;

import com.sts15.enderdrives.datagen.EDDataProvider;
import com.sts15.enderdrives.datagen.assets.EDBlockModelProvider;
import com.sts15.enderdrives.datagen.assets.EDItemModelProvider;
import com.sts15.enderdrives.datagen.data.EDRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="enderdrives", bus=EventBusSubscriber.Bus.MOD)
public class EDDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        EDDataProvider provider = new EDDataProvider();
        provider.addSubProvider(event.includeClient(), (DataProvider)new EDBlockModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new EDItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EDRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)provider);
    }
}

