/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.enchantmentlevelcapindicator_common_neoforge.mixin;

import com.mojang.datafixers.util.Pair;
import com.natamus.enchantmentlevelcapindicator_common_neoforge.config.ConfigHandler;
import com.natamus.enchantmentlevelcapindicator_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemStack.class}, priority=1001)
public class ItemStackMixin {
    @ModifyVariable(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;enabledFeatures()Lnet/minecraft/world/flag/FeatureFlagSet;"))
    public List<Component> getTooltipLines(List<Component> list, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (!ConfigHandler.showSymbolInItemTooltip) {
            return list;
        }
        if (player == null) {
            return list;
        }
        boolean updatedList = false;
        ArrayList<Component> newList = new ArrayList<Component>();
        for (Component component : list) {
            Registry enchantmentRegistry;
            Pair<Enchantment, Integer> enchantmentPair;
            String rawText = component.toString();
            if (rawText.contains("enchantment.") && (enchantmentPair = Util.parseRawComponentText(rawText, (Registry<Enchantment>)(enchantmentRegistry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT)))) != null) {
                int maxLevel;
                Enchantment enchantment = (Enchantment)enchantmentPair.getFirst();
                int level = (Integer)enchantmentPair.getSecond();
                if (level >= (maxLevel = enchantment.getMaxLevel())) {
                    newList.add((Component)component.copy().append(Util.getStarComponent()));
                    updatedList = true;
                    continue;
                }
            }
            newList.add(component);
        }
        if (updatedList) {
            return newList;
        }
        return list;
    }
}

