/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.vertex;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.embeddedt.embeddium.api.vertex.attributes.CommonVertexAttribute;
import org.embeddedt.embeddium.api.vertex.format.VertexFormatDescription;

public class VertexFormatDescriptionImpl
implements VertexFormatDescription {
    private final VertexFormat format;
    private final int id;
    private final int stride;
    private final int[] offsets;
    private final boolean isSimple;

    public VertexFormatDescriptionImpl(VertexFormat format, int id) {
        this.format = format;
        this.id = id;
        this.stride = format.getVertexSize();
        this.offsets = VertexFormatDescriptionImpl.getOffsets(format);
        this.isSimple = VertexFormatDescriptionImpl.checkSimple(format);
    }

    private static boolean checkSimple(VertexFormat format) {
        EnumSet<CommonVertexAttribute> attributeSet = EnumSet.noneOf(CommonVertexAttribute.class);
        List elementList = format.getElements();
        for (int elementIndex = 0; elementIndex < elementList.size(); ++elementIndex) {
            VertexFormatElement element = (VertexFormatElement)elementList.get(elementIndex);
            CommonVertexAttribute commonType = CommonVertexAttribute.getCommonType(element);
            if (commonType != null && attributeSet.add(commonType)) continue;
            return false;
        }
        return true;
    }

    public static int[] getOffsets(VertexFormat format) {
        int[] commonElementOffsets = new int[CommonVertexAttribute.COUNT];
        Arrays.fill(commonElementOffsets, -1);
        List elementList = format.getElements();
        for (int elementIndex = 0; elementIndex < elementList.size(); ++elementIndex) {
            VertexFormatElement element = (VertexFormatElement)elementList.get(elementIndex);
            CommonVertexAttribute commonType = CommonVertexAttribute.getCommonType(element);
            if (commonType == null) continue;
            commonElementOffsets[commonType.ordinal()] = format.getOffset(element);
        }
        return commonElementOffsets;
    }

    @Override
    public boolean containsElement(CommonVertexAttribute element) {
        return this.offsets[element.ordinal()] != -1;
    }

    @Override
    public int getElementOffset(CommonVertexAttribute element) {
        int offset = this.offsets[element.ordinal()];
        if (offset == -1) {
            throw new NoSuchElementException("Vertex format does not contain element: " + String.valueOf((Object)element));
        }
        return offset;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int stride() {
        return this.stride;
    }

    public VertexFormat format() {
        return this.format;
    }

    @Override
    public boolean isSimpleFormat() {
        return this.isSimple;
    }
}

