/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.render.immediate.matrix_stack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import org.embeddedt.embeddium.api.math.MatrixHelper;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={VertexConsumer.class})
public interface VertexConsumerMixin {
    @Shadow
    public VertexConsumer setNormal(float var1, float var2, float var3);

    @Shadow
    public VertexConsumer addVertex(float var1, float var2, float var3);

    @Overwrite
    default public VertexConsumer addVertex(Matrix4f matrix, float x, float y, float z) {
        float xt = MatrixHelper.transformPositionX(matrix, x, y, z);
        float yt = MatrixHelper.transformPositionY(matrix, x, y, z);
        float zt = MatrixHelper.transformPositionZ(matrix, x, y, z);
        return this.addVertex(xt, yt, zt);
    }

    @Overwrite
    default public VertexConsumer setNormal(PoseStack.Pose pose, float x, float y, float z) {
        Matrix3f matrix = pose.normal();
        float xt = MatrixHelper.transformNormalX(matrix, x, y, z);
        float yt = MatrixHelper.transformNormalY(matrix, x, y, z);
        float zt = MatrixHelper.transformNormalZ(matrix, x, y, z);
        if (!pose.trustedNormals) {
            float scalar = Math.invsqrt((float)Math.fma((float)xt, (float)xt, (float)Math.fma((float)yt, (float)yt, (float)(zt * zt))));
            xt *= scalar;
            yt *= scalar;
            zt *= scalar;
        }
        return this.setNormal(xt, yt, zt);
    }
}

