/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.EmbeddiumPreLaunch;
import org.embeddedt.embeddium.impl.asm.AnnotationProcessingEngine;
import org.embeddedt.embeddium.impl.config.ConfigMigrator;
import org.embeddedt.embeddium.impl.mixin.MixinClassValidator;
import org.embeddedt.embeddium.impl.mixin.MixinConfig;
import org.embeddedt.embeddium.impl.mixin.MixinOption;
import org.embeddedt.embeddium_integrity.MixinTaintDetector;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "org.embeddedt.embeddium.impl.mixin.";
    private final Logger logger = LogManager.getLogger((String)"Embeddium");
    private MixinConfig config;
    private static final boolean RUNNING_ON_FABRIC;
    private static final Set<String> BLACKLISTED_MIXINS;

    public void onLoad(String mixinPackage) {
        try {
            this.config = MixinConfig.load(ConfigMigrator.handleConfigMigration("embeddium-mixins.properties").toFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load configuration file for Embeddium", e);
        }
        this.logger.info("Loaded configuration file for Embeddium: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
        EmbeddiumPreLaunch.onPreLaunch();
        MixinTaintDetector.initialize();
        try {
            if (MixinService.getService().getBytecodeProvider().getClassNode("net.caffeinemc.caffeineconfig.AdvancedEmbeddiumHackery") != null) {
                FMLLoader.getLoadingModList().getModLoadingIssues().add(ModLoadingIssue.error((String)"Rubidium/Embeddium Extra by dima_dencep hacks Embeddium to prevent accurate detection of mods causing game issues, it is not supported", (Object[])new Object[0]));
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    private boolean isMixinEnabled(String mixin) {
        MixinOption option = this.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            if (!mixin.startsWith("modcompat.")) {
                this.logger.error("No rules matched mixin '{}', treating as foreign and disabling!", (Object)mixin);
            }
            return false;
        }
        if (option.isOverridden()) {
            Object source = "[unknown]";
            if (option.isUserDefined()) {
                source = "user configuration";
            } else if (option.isModDefined()) {
                source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
            }
            if (option.isEnabled()) {
                this.logger.warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", (Object)mixin, (Object)option.getName(), source);
            } else {
                this.logger.warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", (Object)mixin, (Object)option.getName(), source);
            }
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    private static String mixinClassify(Path baseFolder, Path path) {
        try {
            String className = baseFolder.relativize(path).toString().replace('/', '.').replace('\\', '.');
            return className.substring(0, className.length() - 6);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error relativizing " + String.valueOf(path) + " to " + String.valueOf(baseFolder), e);
        }
    }

    public List<String> getMixins() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            return null;
        }
        ModFileInfo modFileInfo = FMLLoader.getLoadingModList().getModFileById("embeddium");
        if (modFileInfo == null) {
            this.logger.error("Could not find embeddium mod, there is likely a dependency error. Skipping mixin application.");
            return null;
        }
        ModFile modFile = modFileInfo.getFile();
        HashSet<Path> rootPaths = new HashSet<Path>();
        for (String basePackage : new String[]{"core", "modcompat", "fabric"}) {
            Path mixinPackagePath = modFile.findResource(new String[]{"org", "embeddedt", "embeddium", "impl", "mixin", basePackage});
            if (!Files.exists(mixinPackagePath, new LinkOption[0])) continue;
            rootPaths.add(mixinPackagePath.getParent().toAbsolutePath());
        }
        HashSet possibleMixinClasses = new HashSet();
        for (Path rootPath : rootPaths) {
            try {
                Stream<Path> mixinStream = Files.find(rootPath, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);
                try {
                    mixinStream.map(Path::toAbsolutePath).filter(MixinClassValidator::isMixinClass).map(path -> MixinPlugin.mixinClassify(rootPath, path)).filter(this::isMixinEnabled).forEach(possibleMixinClasses::add);
                }
                finally {
                    if (mixinStream == null) continue;
                    mixinStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        possibleMixinClasses.removeAll(BLACKLISTED_MIXINS);
        return new ArrayList<String>(possibleMixinClasses);
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (targetClassName.startsWith("org.embeddedt.embeddium.") || targetClassName.startsWith("me.jellysquid.mods.sodium.")) {
            AnnotationProcessingEngine.processClass(targetClass);
        }
    }

    static {
        boolean mlPresent;
        try {
            Class.forName("cpw.mods.modlauncher.Launcher", false, MixinPlugin.class.getClassLoader());
            String mixinService = System.getProperty("mixin.service");
            mlPresent = mixinService == null || !mixinService.contains("MixinServiceKnot");
        }
        catch (ReflectiveOperationException e) {
            mlPresent = false;
        }
        RUNNING_ON_FABRIC = !mlPresent;
        BLACKLISTED_MIXINS = !RUNNING_ON_FABRIC ? Set.of() : Set.of("features.render.model.ChunkRenderTypeSetMixin");
    }
}

