/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.edibles_common_forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.edibles_common_forge.config.ConfigHandler;
import com.natamus.edibles_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class EdibleEvent {
    private static final List<Item> edibles = new ArrayList<Item>(Arrays.asList(Items.BLAZE_POWDER, Items.MAGMA_CREAM, Items.SUGAR, Items.GHAST_TEAR, Items.PHANTOM_MEMBRANE, Items.RABBIT_FOOT, Items.GLOWSTONE_DUST));
    private static Map<String, Map<Item, Integer>> playeruses = new HashMap<String, Map<Item, Integer>>();
    private static int currentday = -1;

    public static boolean onBlockRightClick(Level world, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        Item mainhanditem;
        if (world.isClientSide) {
            return true;
        }
        if (hand.equals((Object)InteractionHand.OFF_HAND) && edibles.contains(mainhanditem = player.getMainHandItem().getItem())) {
            player.getInventory().setChanged();
            return false;
        }
        return true;
    }

    public static InteractionResultHolder<ItemStack> onClickEmpty(Player player, Level world, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        String playername = player.getName().getString();
        Item item = itemstack.getItem();
        if (item.equals(Items.BLAZE_POWDER)) {
            if (ConfigHandler.blazePowderStrengthDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            effect = new MobEffectInstance(MobEffects.DAMAGE_BOOST, ConfigHandler.blazePowderStrengthDurationSeconds * 20);
            player.addEffect(effect);
        } else if (item.equals(Items.MAGMA_CREAM)) {
            if (ConfigHandler.magmaCreamFireResistanceDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            effect = new MobEffectInstance(MobEffects.FIRE_RESISTANCE, ConfigHandler.magmaCreamFireResistanceDurationSeconds * 20);
            player.addEffect(effect);
        } else if (item.equals(Items.SUGAR)) {
            if (ConfigHandler.sugarSpeedDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            effect = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, ConfigHandler.sugarSpeedDurationSeconds * 20);
            player.addEffect(effect);
        } else if (item.equals(Items.GHAST_TEAR)) {
            if (ConfigHandler.ghastTearDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            effect = new MobEffectInstance(MobEffects.REGENERATION, ConfigHandler.ghastTearDurationSeconds * 20);
            player.addEffect(effect);
        } else if (item.equals(Items.PHANTOM_MEMBRANE)) {
            if (ConfigHandler.phantomMembraneDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            effect = new MobEffectInstance(MobEffects.SLOW_FALLING, ConfigHandler.phantomMembraneDurationSeconds * 20);
            player.addEffect(effect);
        } else if (item.equals(Items.RABBIT_FOOT)) {
            if (ConfigHandler.rabbitsFootDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            effect = new MobEffectInstance(MobEffects.JUMP, ConfigHandler.rabbitsFootDurationSeconds * 20);
            player.addEffect(effect);
        } else if (item.equals(Items.GLOWSTONE_DUST)) {
            if (ConfigHandler.glowEntityDurationSeconds == 0) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!Util.canPlayerUse(playername)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            BlockPos pos = player.blockPosition();
            int r = ConfigHandler.glowEntitiesAroundAffectedRadiusBlocks;
            MobEffectInstance effect = new MobEffectInstance(MobEffects.GLOWING, ConfigHandler.glowEntityDurationSeconds * 200);
            for (Entity ne : world.getEntities((Entity)player, new AABB((double)(pos.getX() - r), (double)(pos.getY() - r), (double)(pos.getZ() - r), (double)(pos.getX() + r), (double)(pos.getY() + r), (double)(pos.getZ() + r)))) {
                if (!(ne instanceof LivingEntity) || ne instanceof Player) continue;
                ((LivingEntity)ne).addEffect(effect);
            }
        } else {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        player.swing(hand);
        Util.setPlayerUse(playername);
        if (!player.isCreative()) {
            itemstack.shrink(1);
        }
        if (ConfigHandler.maxItemUsesPerDaySingleItem != -1 || ConfigHandler.maxItemUsesPerDayTotal != -1) {
            int days = WorldFunctions.getTotalDaysPassed((ServerLevel)((ServerLevel)world));
            if (currentday != days) {
                playeruses = new HashMap<String, Map<Item, Integer>>();
                currentday = days;
            }
            Map<Object, Object> currentuses = new HashMap();
            if (playeruses.containsKey(playername)) {
                currentuses = playeruses.get(playername);
            }
            int dayuses = 1;
            if (currentuses.containsKey(item)) {
                dayuses = (Integer)currentuses.get(item) + 1;
            }
            currentuses.put(item, dayuses);
            if (dayuses > ConfigHandler.maxItemUsesPerDaySingleItem && ConfigHandler.maxItemUsesPerDaySingleItem != -1) {
                MobEffectInstance weakness = new MobEffectInstance(MobEffects.WEAKNESS, ConfigHandler.weaknessDurationSeconds * 20);
                player.addEffect(weakness);
            } else if (currentuses.size() > 1 && ConfigHandler.maxItemUsesPerDayTotal != -1) {
                Entity ne;
                int totaluses = 0;
                ne = currentuses.values().iterator();
                while (ne.hasNext()) {
                    int dayuse = (Integer)ne.next();
                    totaluses += dayuse;
                }
                if (totaluses > ConfigHandler.maxItemUsesPerDayTotal) {
                    MobEffectInstance weakness = new MobEffectInstance(MobEffects.WEAKNESS, ConfigHandler.weaknessDurationSeconds * 20);
                    player.addEffect(weakness);
                }
            }
            playeruses.put(playername, currentuses);
        }
        return InteractionResultHolder.success((Object)itemstack);
    }
}

