/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.api.worldgen.GroundFinder;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class SubterraneanGroundFinder
implements GroundFinder {
    private static final List<BlockPos> NO_LAYERS = Collections.singletonList(BlockPos.ZERO);

    protected boolean isReplaceable(LevelAccessor level, BlockPos pos) {
        return (level.isEmptyBlock(pos) || level.getBlockState(pos).is(BlockTags.REPLACEABLE_BY_TREES)) && level.getBlockState(pos).getFluidState().isEmpty();
    }

    protected int getTopY(LevelAccessor level, BlockPos pos) {
        return level.getChunk(pos).getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
    }

    protected ArrayList<Integer> findSubterraneanLayerHeights(LevelAccessor level, BlockPos start) {
        int maxY = this.getTopY(level, start);
        int minY = level.getMinBuildHeight();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(start.getX(), minY, start.getZ());
        ArrayList<Integer> layers = new ArrayList<Integer>();
        while (CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
            while (!this.isReplaceable(level, (BlockPos)pos) && CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
                pos.move(Direction.UP, 4);
            }
            while (this.isReplaceable(level, (BlockPos)pos) && CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
                pos.move(Direction.DOWN);
            }
            if (this.isReplaceable(level, pos.above(6))) {
                layers.add(pos.getY());
            }
            pos.move(Direction.UP, 8);
            while (this.isReplaceable(level, (BlockPos)pos) && CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
                pos.move(Direction.UP, 4);
            }
        }
        if (!layers.isEmpty()) {
            layers.removeLast();
        }
        return layers;
    }

    @Override
    public List<BlockPos> findGround(LevelAccessor level, BlockPos start, @Nullable Heightmap.Types heightmap) {
        ArrayList<Integer> layers = this.findSubterraneanLayerHeights(level, start);
        if (layers.isEmpty()) {
            return NO_LAYERS;
        }
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        for (int y : layers) {
            BlockPos pos = new BlockPos(start.getX(), y, start.getZ());
            if (!level.dimensionType().hasCeiling() && !level.getBiome(pos).is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"c:is_underground")))) continue;
            positions.add(pos);
        }
        return positions;
    }
}

