/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.utility;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class NullUtils {
    public static boolean isNotNull(@Nullable Object obj) {
        return obj != null;
    }

    public static <T> boolean consumeIfNonnull(@Nullable T obj, Consumer<T> nonnullConsumer) {
        if (NullUtils.isNotNull(obj)) {
            nonnullConsumer.accept(obj);
            return true;
        }
        return false;
    }

    @Nullable
    public static <T, R> R applyIfNonnull(@Nullable T obj, Function<T, R> function) {
        if (NullUtils.isNotNull(obj)) {
            return function.apply(obj);
        }
        return null;
    }

    public static <T, R> R applyIfNonnull(@Nullable T obj, Function<T, R> function, R defaultReturn) {
        if (NullUtils.isNotNull(obj)) {
            return function.apply(obj);
        }
        return defaultReturn;
    }
}

