/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.treepack;

import com.dtteam.dynamictrees.api.resource.TreeResourcePack;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TreePackResources
extends PathPackResources
implements TreeResourcePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path root;

    public TreePackResources(PackLocationInfo location, Path root) {
        super(location, root);
        this.root = root;
    }

    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        return this.getRootResource(TreePackResources.getPathFromLocation(location));
    }

    private static String[] getPathFromLocation(ResourceLocation location) {
        String[] parts = location.getPath().split("/");
        String[] result = new String[parts.length + 1];
        result[0] = location.getNamespace();
        System.arraycopy(parts, 0, result, 1, parts.length);
        return result;
    }

    public void listResources(@Nullable PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        FileUtil.decomposePath((String)path).ifSuccess(parts -> PathPackResources.listPath((String)namespace, (Path)this.root.resolve(namespace).toAbsolutePath(), (List)parts, (PackResources.ResourceOutput)resourceOutput)).ifError(dataResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)dataResult.message()));
    }

    public Set<String> getNamespaces(@Nullable PackType type) {
        Set<String> set;
        block8: {
            Stream<Path> walker = Files.walk(this.root, 1, new FileVisitOption[0]);
            try {
                set = walker.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(this.root::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                if (walker == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | AssertionError e) {
                    return Set.of();
                }
            }
            walker.close();
        }
        return set;
    }
}

