/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree.species;

import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.leaves.PalmLeavesProperties;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKits;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.family.PalmFamily;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.mojang.datafixers.util.Function3;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class PalmSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = PalmSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)PalmSpecies::new));

    public PalmSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
        if (!(family instanceof PalmFamily)) {
            LogManager.getLogger().warn("Family {} for palm species {} is not of type {}", (Object)family.getRegistryName(), (Object)this.getRegistryName(), PalmFamily.class);
        }
        if (!(leavesProperties instanceof PalmLeavesProperties)) {
            LogManager.getLogger().warn("LeavesProperties {} for palm species {} is not of type {}", (Object)leavesProperties.getRegistryName(), (Object)this.getRegistryName(), PalmLeavesProperties.class);
        }
        this.setGrowthLogicKit(GrowthLogicKits.PALM);
    }

    @Override
    public boolean postGrow(Level level, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        BlockState trunkBlockState = level.getBlockState(treePos);
        BranchBlock branch = TreeHelper.getBranch(trunkBlockState);
        if (branch == null) {
            return false;
        }
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(endFinder);
        branch.analyse(trunkBlockState, (LevelAccessor)level, treePos, Direction.DOWN, signal);
        List<BlockPos> endPoints = endFinder.getEnds();
        for (BlockPos endPoint : endPoints) {
            TreeHelper.ageVolume((LevelAccessor)level, endPoint, 2, 3, 3, false);
        }
        int radius = branch.getRadius(level.getBlockState(treePos.above()));
        if (radius != 0) {
            branch.setRadius((LevelAccessor)level, treePos, radius + 1, null);
        }
        return super.postGrow(level, rootPos, treePos, fertility, natural);
    }

    @Override
    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
        level.setBlockAndUpdate(pos.above(), (BlockState)this.getLeavesProperties().getDynamicLeavesState().setValue((Property)DynamicLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(4)));
        level.setBlockAndUpdate(pos.above(2), (BlockState)this.getLeavesProperties().getDynamicLeavesState().setValue((Property)DynamicLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(3)));
        this.placeRootyDirtBlock((LevelAccessor)level, pos.below(), 15);
        return true;
    }

    @Override
    public void postGeneration(PostGenerationContext context) {
        LevelAccessor level = context.level();
        for (BlockPos endPoint : context.endPoints()) {
            BlockPos tip = endPoint.above(2);
            if (!(level.getBlockState(tip).getBlock() instanceof DynamicLeavesBlock)) continue;
            for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
                BlockPos leafPos = tip.offset(surr.getOffset());
                BlockState leafState = level.getBlockState(leafPos);
                Block block = leafState.getBlock();
                if (!(block instanceof DynamicLeavesBlock)) continue;
                DynamicLeavesBlock block2 = (DynamicLeavesBlock)block;
                level.setBlock(leafPos, block2.getLeavesBlockStateForPlacement(level, leafPos, leafState, (Integer)leafState.getValue((Property)LeavesBlock.DISTANCE), true), 2);
            }
        }
        super.postGeneration(context);
    }

    @Override
    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        int endPointsNum = destructionData.getNumEndpoints();
        if (endPointsNum < 1) {
            return null;
        }
        HashMap<BlockPos, BlockState> leaves = new HashMap<BlockPos, BlockState>();
        for (int i = 0; i < endPointsNum; ++i) {
            BlockPos relPos = destructionData.getEndPointRelPos(i).above(2);
            relPos = relPos.below();
            LeavesProperties leavesProperties = destructionData.species.getLeavesProperties();
            HashSet<BlockPos> existingLeaves = new HashSet<BlockPos>();
            for (int j = 0; j < destructionData.getNumLeaves(); ++j) {
                existingLeaves.add(destructionData.getLeavesRelPos(j));
            }
            if (existingLeaves.contains(relPos)) {
                leaves.put(relPos, leavesProperties.getDynamicLeavesState(4));
            }
            if (existingLeaves.contains(relPos.above())) {
                leaves.put(relPos.above(), leavesProperties.getDynamicLeavesState(3));
            }
            for (int hydro = 1; hydro <= 2; ++hydro) {
                BlockState state = leavesProperties.getDynamicLeavesState(hydro);
                for (CoordUtils.Surround surr : PalmLeavesProperties.DynamicPalmLeavesBlock.hydroSurroundMap[hydro]) {
                    BlockPos leafPos = relPos.above().offset(surr.getOpposite().getOffset());
                    if (!existingLeaves.contains(leafPos)) continue;
                    leaves.put(leafPos, PalmLeavesProperties.DynamicPalmLeavesBlock.getDirectionState(state, surr));
                }
            }
        }
        return leaves;
    }
}

