/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree.family;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BasicRootsBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.AerialRootsSoilProperties;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.tree.species.UndergroundRootsSpecies;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class UndergroundRootsFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(UndergroundRootsFamily::new);
    private AerialRootsSoilProperties defaultSoil;
    private Supplier<BranchBlock> roots;
    private Supplier<Item> rootsItem;
    private Block primitiveRoots;
    private Block primitiveRootsFilled;
    private Block primitiveRootsCovered;
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, Family>> rootsStateGenerator = MutableLazyValue.supplied((Supplier)blockStateGenerators.get(DynamicTrees.location("roots")));
    protected final MutableLazyValue<Generator<DTDataProvider.ItemModel, Family>> rootsItemModelGenerator = MutableLazyValue.supplied((Supplier)itemModelGenerators.get(DynamicTrees.location("roots_item")));
    protected int rootSystemSoilTypeFlags = 0;
    private int primaryRootThickness = 2;
    private int secondaryRootThickness = 3;
    private int supportedRootThicknessExtra = 2;

    public UndergroundRootsFamily(ResourceLocation name) {
        super(name);
    }

    @Override
    public void setCommonSpecies(Species species) {
        super.setCommonSpecies(species);
        if (!(species instanceof UndergroundRootsSpecies)) {
            LogManager.getLogger().warn("Common species {} for Underground Roots Family {} is not of type {}", (Object)species.getRegistryName(), (Object)this.getRegistryName(), UndergroundRootsSpecies.class);
        }
    }

    public void setDefaultSoil(SoilProperties defaultSoil) {
        if (!(defaultSoil instanceof AerialRootsSoilProperties)) {
            throw new RuntimeException("Soil " + defaultSoil.toString() + " for Underground Roots Family " + String.valueOf(this) + " is not of type " + String.valueOf(AerialRootsSoilProperties.class));
        }
        this.defaultSoil = (AerialRootsSoilProperties)defaultSoil;
        this.defaultSoil.setFamily(this);
    }

    public AerialRootsSoilProperties getDefaultSoil() {
        return this.defaultSoil;
    }

    @Override
    public void setupBlocks() {
        super.setupBlocks();
        this.setRoots(this.createRoots(this.getBranchName()));
        this.setRootsItem(this.createRootsItem(this.getBranchName(), this.roots));
    }

    protected Supplier<BranchBlock> createRoots(ResourceLocation name) {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(name, this.getRootsNameSuffix()), () -> this.createRootsBlock(name));
    }

    protected BranchBlock createRootsBlock(ResourceLocation name) {
        BasicRootsBlock branch = new BasicRootsBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    public Supplier<BlockItem> createRootsItem(ResourceLocation registryName, Supplier<BranchBlock> rootsSup) {
        return RegistryHandler.addItem(ResourceLocationUtils.suffix(registryName, this.getRootsNameSuffix()), () -> new BlockItem((Block)rootsSup.get(), new Item.Properties()));
    }

    protected String getRootsNameSuffix() {
        return "_roots";
    }

    public Family setRoots(Supplier<BranchBlock> branchSup) {
        this.roots = this.setupBranch(branchSup, false);
        return this;
    }

    protected <T extends Item> Family setRootsItem(Supplier<T> branchItemSup) {
        this.rootsItem = branchItemSup;
        return this;
    }

    public Optional<BranchBlock> getRoots() {
        return Optionals.ofBlock(this.roots);
    }

    public Optional<Item> getRootsItem() {
        return Optionals.ofItem(this.rootsItem);
    }

    @Override
    public Optional<BranchBlock> getBranchForRootsPlacement(LevelAccessor level, Species species, BlockPos pos) {
        return this.getRoots();
    }

    @Override
    public void generateStateData(DTDataProvider.BlockState provider) {
        super.generateStateData(provider);
        this.rootsStateGenerator.get().generate(provider, this);
    }

    @Override
    public void generateItemModelData(DTDataProvider.ItemModel provider) {
        super.generateItemModelData(provider);
        this.rootsItemModelGenerator.get().generate(provider, this);
    }

    @Override
    public ResourceLocation getBranchItemParentLocation() {
        return DynamicTrees.location("item/branch");
    }

    public List<TagKey<Block>> defaultRootsTags() {
        return Collections.singletonList(DTBlockTags.ROOTS);
    }

    @Nullable
    public Tier getDefaultRootsHarvestTier() {
        return null;
    }

    @Override
    public boolean isAcceptableSoilForRootSystem(BlockState soilBlockState) {
        return soilBlockState.getBlock() instanceof AerialRootsSoilProperties.RootSoilBlock || SoilHelper.isSoilAcceptable(soilBlockState, this.rootSystemSoilTypeFlags);
    }

    public Family addAcceptableSoilsForRootSystem(String ... soilTypes) {
        this.rootSystemSoilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    @Override
    public boolean hasRootSystem() {
        return true;
    }

    public int getPrimaryRootThickness() {
        return this.primaryRootThickness;
    }

    public int getSecondaryRootThickness() {
        return this.secondaryRootThickness;
    }

    public int getSupportedRootThicknessExtra() {
        return this.supportedRootThicknessExtra;
    }

    public void setPrimaryRootThickness(int primaryRootThickness) {
        this.primaryRootThickness = primaryRootThickness;
    }

    public void setSecondaryRootThickness(int secondaryRootThickness) {
        this.secondaryRootThickness = secondaryRootThickness;
    }

    public void setSupportedRootThicknessExtra(int supportedRootThicknessExtra) {
        this.supportedRootThicknessExtra = supportedRootThicknessExtra;
    }

    public void setPrimitiveRoots(Block primitiveRoots) {
        this.primitiveRoots = primitiveRoots;
        if (this.roots != null) {
            this.roots.get().setPrimitiveLogDrops(new ItemStack((ItemLike)primitiveRoots));
        }
    }

    public void setPrimitiveRootsFilled(Block primitiveRootsFilled) {
        this.primitiveRootsFilled = primitiveRootsFilled;
    }

    public void setPrimitiveRootsCovered(Block primitiveRootsCovered) {
        this.primitiveRootsCovered = primitiveRootsCovered;
    }

    public Optional<Block> getPrimitiveRoots() {
        return Optionals.ofBlock(this.primitiveRoots);
    }

    public Optional<Block> getPrimitiveFilledRoots() {
        return Optionals.ofBlock(this.primitiveRootsFilled);
    }

    public Optional<Block> getPrimitiveCoveredRoots() {
        return Optionals.ofBlock(this.primitiveRootsCovered);
    }

    @Override
    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        super.addGeneratedBlockTags(tagAppender);
        this.getRoots().ifPresent(roots -> {
            this.tierTag(this.getDefaultRootsHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.add(roots));
            this.defaultRootsTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).add(roots);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).addOptional(BuiltInRegistries.BLOCK.getKey(roots));
                }
            });
        });
    }
}

