/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.substance;

import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.substance.SubstanceEffect;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.client.ParticleHelper;
import com.dtteam.dynamictrees.systems.genfeature.FruitGenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.PodGenFeature;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestSubstance
implements SubstanceEffect {
    private Species species = Species.NULL_SPECIES;
    private final int duration;
    private final int ticksPerParticlePulse;
    private final int ticksPerGrowthPulse;
    private final int growthPulses;
    private final int ticksPerSpawnAttempt;
    public final Set<BlockPos> fruitPositions = Sets.newHashSet();

    public HarvestSubstance() {
        this(1600, 12, 12, 1, 16);
    }

    public HarvestSubstance(int duration, int ticksPerParticlePulse, int ticksPerGrowthPulse, int growthPulses, int ticksPerSpawnAttempt) {
        this.duration = duration;
        this.ticksPerParticlePulse = ticksPerParticlePulse;
        this.ticksPerGrowthPulse = ticksPerGrowthPulse;
        this.growthPulses = growthPulses;
        this.ticksPerSpawnAttempt = ticksPerSpawnAttempt;
    }

    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        BlockState rootState = level.getBlockState(rootPos);
        SoilBlock soilBlock = TreeHelper.getRooty(rootState);
        if (soilBlock == null) {
            return false;
        }
        this.species = soilBlock.getSpecies(rootState, (LevelAccessor)level, rootPos);
        if (!this.species.hasFruits()) {
            return false;
        }
        this.recalculateFruitPositions((LevelAccessor)level, rootPos, soilBlock);
        return true;
    }

    private void recalculateFruitPositions(LevelAccessor level, BlockPos rootPos, SoilBlock soilBlock) {
        this.fruitPositions.clear();
        FindEndsNode findEndsNode = new FindEndsNode();
        soilBlock.startAnalysis(level, rootPos, new MapSignal(findEndsNode));
        findEndsNode.getEnds().forEach(endPos -> BlockPos.betweenClosedStream((BlockPos)endPos.offset(-3, -3, -3), (BlockPos)endPos.offset(3, 3, 3)).forEach(pos -> {
            if (this.isCompatibleFruitBlock(level, (BlockPos)pos)) {
                this.fruitPositions.add(pos.immutable());
            }
        }));
    }

    private boolean isCompatibleFruitBlock(LevelAccessor level, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        return this.isCompatibleFruitBlock(block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCompatibleFruitBlock(Block block) {
        if (!(block instanceof FruitBlock)) return false;
        if (!this.species.getFruits().stream().map(Fruit::getBlock).anyMatch(block::equals)) return false;
        return true;
    }

    @Override
    public boolean update(Level level, BlockPos rootPos, int deltaTicks, int fertility) {
        if (deltaTicks > this.duration) {
            return false;
        }
        SoilBlock soilBlock = TreeHelper.getRooty(level.getBlockState(rootPos));
        if (soilBlock == null) {
            return false;
        }
        if (level.isClientSide) {
            if (deltaTicks % this.ticksPerParticlePulse == 0) {
                this.recalculateFruitPositions((LevelAccessor)level, rootPos, soilBlock);
                this.fruitPositions.forEach(fruitPos -> ParticleHelper.spawnParticles((LevelAccessor)level, ParticleTypes.EFFECT, fruitPos.getX(), fruitPos.getY(), fruitPos.getZ(), 3, level.getRandom()));
            }
        } else {
            boolean spawnAttempt;
            boolean growPulse = deltaTicks % this.ticksPerGrowthPulse == 0;
            boolean bl = spawnAttempt = deltaTicks % this.ticksPerSpawnAttempt == 0;
            if (growPulse || spawnAttempt) {
                this.recalculateFruitPositions((LevelAccessor)level, rootPos, soilBlock);
            }
            if (growPulse) {
                this.fruitPositions.removeIf(fruitPos -> {
                    BlockState state = level.getBlockState(fruitPos);
                    Block block = state.getBlock();
                    if (!this.isCompatibleFruitBlock(block)) {
                        return true;
                    }
                    for (int i = 0; i < this.growthPulses; ++i) {
                        ((FruitBlock)block).doTick(state, level, (BlockPos)fruitPos, level.random);
                    }
                    return false;
                });
            }
            if (spawnAttempt) {
                this.species.getGenFeatures().stream().filter(configuration -> configuration.getGenFeature() instanceof FruitGenFeature || configuration.getGenFeature() instanceof PodGenFeature).forEach(configuration -> configuration.generate(GenFeature.Type.POST_GROW, new PostGrowContext(level, rootPos, this.species, rootPos.relative(soilBlock.getTrunkDirection((BlockGetter)level, rootPos)), fertility, true)));
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "harvest";
    }

    @Override
    public boolean isLingering() {
        return true;
    }
}

