/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.substance;

import com.dtteam.dynamictrees.api.substance.SubstanceEffect;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;

public class FertilizeSubstance
implements SubstanceEffect {
    private int amount = 2;
    private boolean displayParticles = true;
    private boolean grow;
    private Supplier<Integer> pulses = () -> 1;

    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        SoilBlock dirt = TreeHelper.getRooty(level.getBlockState(rootPos));
        if (dirt != null && dirt.fertilize(level, rootPos, this.amount) || this.grow) {
            if (this.displayParticles && level.isClientSide) {
                TreeHelper.treeParticles(level, rootPos, ParticleTypes.HAPPY_VILLAGER, 8);
            } else if (this.grow) {
                int pulses = this.pulses.get();
                for (int i = 0; i < pulses; ++i) {
                    TreeHelper.growPulse(level, rootPos);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "fertilize";
    }

    public FertilizeSubstance setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public FertilizeSubstance setGrow(boolean grow) {
        this.grow = grow;
        return this;
    }

    public FertilizeSubstance setPulses(int pulses) {
        return this.setPulses(() -> pulses);
    }

    public FertilizeSubstance setDisplayParticles(boolean displayParticles) {
        this.displayParticles = displayParticles;
        return this;
    }

    public FertilizeSubstance setPulses(Supplier<Integer> pulses) {
        this.pulses = pulses;
        return this;
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

