/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.SeasonManager;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.season.NormalSeasonManager;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;

public final class SeasonCompatibilityHandler {
    private static final LinkedHashMap<String, Supplier<SeasonManager>> SEASON_MANAGERS = Maps.newLinkedHashMap();
    public static final String DISABLED = "!";
    public static final String ANY = "*";

    public static void registerSeasonManager(String modId, Supplier<SeasonManager> supplier) {
        SEASON_MANAGERS.put(modId, supplier);
    }

    public static void registerBuiltInSeasonManagers() {
        if (Services.PLATFORM.isModLoaded("sereneseasons")) {
            Services.COMPAT.registerSereneSeasonsSeasonProvider();
        }
    }

    public static void reloadSeasonManager() {
        String modId = Services.CONFIG.getStringConfig("preferredSeasonMod");
        if (Objects.equals(modId, DISABLED)) {
            SeasonHelper.setSeasonManager(NormalSeasonManager.NULL.get());
            return;
        }
        if (Objects.equals(modId, ANY)) {
            SeasonHelper.setSeasonManager(SEASON_MANAGERS.entrySet().stream().filter(entry -> Services.PLATFORM.isModLoaded((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(NormalSeasonManager.NULL).get());
            return;
        }
        if (!Services.PLATFORM.isModLoaded(modId)) {
            LogManager.getLogger().warn("Preferred season mod \"{}\" not installed.", (Object)modId);
            return;
        }
        if (!SEASON_MANAGERS.containsKey(modId)) {
            LogManager.getLogger().warn("Season manager not found for preferred season mod \"{}\".", (Object)modId);
            return;
        }
        SeasonHelper.setSeasonManager(SEASON_MANAGERS.get(modId).get());
    }
}

