/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DenuderNode
implements NodeInspector {
    private final Species species;
    private final Family family;

    public DenuderNode(Species species, Family family) {
        this.species = species;
        this.family = family;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch == null || this.family.getBranch().map(other -> branch != other).orElse(false).booleanValue()) {
            return false;
        }
        int radius = branch.getRadius(state);
        branch.stripBranch(state, level, pos, radius);
        if (radius <= this.family.getPrimaryThickness()) {
            this.removeSurroundingLeaves(level, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void removeSurroundingLeaves(LevelAccessor world, BlockPos twigPos) {
        if (world.isClientSide()) {
            return;
        }
        SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
        int xBound = leafCluster.getLenX();
        int yBound = leafCluster.getLenY();
        int zBound = leafCluster.getLenZ();
        BlockPos.betweenClosedStream((BlockPos)twigPos.offset(-xBound, -yBound, -zBound), (BlockPos)twigPos.offset(xBound, yBound, zBound)).forEach(testPos -> {
            if (leafCluster.getVoxel(twigPos, (BlockPos)testPos) == 0) {
                return;
            }
            BlockState state = world.getBlockState(testPos);
            if (this.family.isCompatibleGenericLeaves(this.species, state, world, (BlockPos)testPos)) {
                world.setBlock(testPos, Blocks.AIR.defaultBlockState(), 3);
            }
        });
    }
}

