/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AlternativeLeavesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<LeavesProperties> ALT_LEAVES = ConfigurationProperty.property("alternative_leaves", LeavesProperties.class);
    public static final ConfigurationProperty<Block> ALT_LEAVES_BLOCK = ConfigurationProperty.block("alternative_leaves_block");

    public AlternativeLeavesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(ALT_LEAVES, ALT_LEAVES_BLOCK, PLACE_CHANCE, QUANTITY);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(ALT_LEAVES, LeavesProperties.NULL)).with(ALT_LEAVES_BLOCK, Blocks.AIR)).with(PLACE_CHANCE, Float.valueOf(0.5f))).with(QUANTITY, 5);
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        configuration.get(ALT_LEAVES).ifValid(properties -> {
            properties.setFamily(species.getFamily());
            species.addValidLeafBlocks((LeavesProperties)properties);
        });
        return true;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPosBounds bounds = context.species().getFamily().expandLeavesBlockBounds(new BlockPosBounds(context.endPoints()));
        return this.setAltLeaves(configuration, context.level(), bounds, context.isWorldGen(), context.species());
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor world = context.level();
        Species species = context.species();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(world, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        BlockPos chosenEndPoint = endPoints.get(world.getRandom().nextInt(endPoints.size()));
        BlockPosBounds bounds = species.getFamily().expandLeavesBlockBounds(new BlockPosBounds(chosenEndPoint));
        return this.setAltLeaves(configuration, world, bounds, false, species);
    }

    private Block getAltLeavesBlock(GenFeatureConfiguration conifuration) {
        LeavesProperties properties = conifuration.get(ALT_LEAVES);
        if (!properties.isValid() || !properties.getDynamicLeavesBlock().isPresent()) {
            return conifuration.get(ALT_LEAVES_BLOCK);
        }
        return (Block)properties.getDynamicLeavesBlock().get();
    }

    private BlockState getSwapBlockState(GenFeatureConfiguration configuration, LevelAccessor world, Species species, BlockState state, boolean worldgen) {
        DynamicLeavesBlock altLeaves;
        DynamicLeavesBlock originalLeaves = species.getLeavesBlock().orElse(null);
        Block alt = this.getAltLeavesBlock(configuration);
        DynamicLeavesBlock dynamicLeavesBlock = altLeaves = alt instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)alt : null;
        if (originalLeaves != null && altLeaves != null) {
            if (worldgen || world.getRandom().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
                if (state.getBlock() == originalLeaves) {
                    return altLeaves.properties.getDynamicLeavesState((Integer)state.getValue((Property)LeavesBlock.DISTANCE));
                }
            } else if (state.getBlock() == altLeaves) {
                return originalLeaves.properties.getDynamicLeavesState((Integer)state.getValue((Property)LeavesBlock.DISTANCE));
            }
        }
        return state;
    }

    private boolean setAltLeaves(GenFeatureConfiguration configuration, LevelAccessor world, BlockPosBounds leafPositions, boolean worldGen, Species species) {
        if (worldGen) {
            AtomicBoolean isSet = new AtomicBoolean(false);
            leafPositions.iterator().forEachRemaining(pos -> {
                if (world.getRandom().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue() && world.setBlock(pos, this.getSwapBlockState(configuration, world, species, world.getBlockState(pos), true), 2)) {
                    isSet.set(true);
                }
            });
            return isSet.get();
        }
        boolean isSet = false;
        LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
        for (BlockPos leafPosition : leafPositions) {
            posList.add(new BlockPos((Vec3i)leafPosition));
        }
        if (posList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < (Integer)configuration.get(QUANTITY); ++i) {
            BlockPos pos2 = (BlockPos)posList.get(world.getRandom().nextInt(posList.size()));
            if (!world.setBlock(pos2, this.getSwapBlockState(configuration, world, species, world.getBlockState(pos2), false), 2)) continue;
            isSet = true;
        }
        return isSet;
    }
}

