/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems;

import com.dtteam.dynamictrees.utility.Optionals;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeedSaplingRecipe {
    public static final Codec<SeedSaplingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("sapling_block").forGetter(SeedSaplingRecipe::getSaplingBlock), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("sapling_item").forGetter(SeedSaplingRecipe::getSaplingItem)).apply((Applicative)instance, (saplingBlock, saplingItem) -> new SeedSaplingRecipe(saplingBlock.orElse(null), saplingItem.orElseGet(() -> ((Block)saplingBlock.orElseThrow(() -> new RuntimeException("Seed-Sapling recipe requires either a block or item, at least."))).asItem()))));
    private final List<Item> extraIngredientsForSaplingToSeed = new LinkedList<Item>();
    private final List<Item> extraIngredientsForSeedToSapling = new LinkedList<Item>();
    private Block saplingBlock;
    private Item saplingItem;
    private boolean canCraftSaplingToSeed = true;
    private boolean canCraftSeedToSapling = true;
    private boolean replaceSaplingWhenPlaced = true;

    public SeedSaplingRecipe(@Nullable Block saplingBlock, Item saplingItem) {
        this(saplingItem);
        this.saplingBlock = saplingBlock;
    }

    public SeedSaplingRecipe(Item saplingItem) {
        this.setSaplingItem(saplingItem);
    }

    public void addExtraIngredientForSaplingToSeed(Item ingredient) {
        this.extraIngredientsForSaplingToSeed.add(ingredient);
    }

    public void addExtraIngredientForSeedToSapling(Item ingredient) {
        this.extraIngredientsForSeedToSapling.add(ingredient);
    }

    public void setCanCraftSaplingToSeed(boolean canCraftSaplingToSeed) {
        this.canCraftSaplingToSeed = canCraftSaplingToSeed;
    }

    public void setCanCraftSeedToSapling(boolean canCraftSeedToSapling) {
        this.canCraftSeedToSapling = canCraftSeedToSapling;
    }

    public void setReplaceSaplingWhenPlaced(boolean replaceSaplingWhenPlaced) {
        this.replaceSaplingWhenPlaced = replaceSaplingWhenPlaced;
    }

    public Optional<Item> getSaplingItem() {
        return Optionals.ofItem(this.saplingItem);
    }

    public SeedSaplingRecipe setSaplingItem(Item saplingItem) {
        this.saplingItem = saplingItem;
        return this;
    }

    public boolean isValid() {
        return this.getSaplingItem().isPresent();
    }

    @NotNull
    public Optional<Block> getSaplingBlock() {
        return Optionals.ofBlock(this.saplingBlock);
    }

    @NotNull
    public List<Item> getIngredientsForSaplingToSeed() {
        return new LinkedList<Item>(this.extraIngredientsForSaplingToSeed);
    }

    @NotNull
    public List<Item> getIngredientsForSeedToSapling() {
        return new LinkedList<Item>(this.extraIngredientsForSeedToSapling);
    }

    public boolean canCraftSaplingToSeed() {
        return this.canCraftSaplingToSeed;
    }

    public boolean canCraftSeedToSapling() {
        return this.canCraftSeedToSapling;
    }

    public boolean shouldReplaceSaplingWhenPlaced() {
        return this.replaceSaplingWhenPlaced;
    }
}

