/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.baked;

import com.dtteam.dynamictrees.block.leaves.PalmLeavesProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class PalmLeavesBakedModel
implements IDynamicBakedModel {
    protected RenderTypeGroup renderGroup = new RenderTypeGroup(RenderType.cutout(), RenderType.cutout());
    protected final BlockModel blockModel;
    TextureAtlasSprite frondsTexture;
    protected final BakedModel[] bakedFronds = new BakedModel[8];

    public PalmLeavesBakedModel(ResourceLocation frondsResLoc, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.NO_TRANSFORMS, new ArrayList());
        this.frondsTexture = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, frondsResLoc));
        this.initModels();
    }

    public abstract void initModels();

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        int direction = (Integer)state.getValue((Property)PalmLeavesProperties.DynamicPalmLeavesBlock.DIRECTION);
        if (direction != 0) {
            quads.addAll(this.bakedFronds[direction - 1].getQuads(state, null, rand, extraData, renderType));
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.frondsTexture;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutoutMipped()});
    }

    public static class BlockVertexData {
        public float x;
        public float y;
        public float z;
        public int color;
        public float u;
        public float v;

        public BlockVertexData(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.color = -1;
        }

        public BlockVertexData(BakedQuad quad, int vIndex) {
            this(quad.getVertices(), vIndex);
        }

        public BlockVertexData(int[] data, int vIndex) {
            vIndex *= 8;
            this.x = Float.intBitsToFloat(data[vIndex++]);
            this.y = Float.intBitsToFloat(data[vIndex++]);
            this.z = Float.intBitsToFloat(data[vIndex++]);
            this.color = data[vIndex++];
            this.u = Float.intBitsToFloat(data[vIndex++]);
            this.v = Float.intBitsToFloat(data[vIndex]);
        }

        public int[] toInts() {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(this.u), Float.floatToRawIntBits(this.v), 0, 0};
        }

        protected int[] toInts(TextureAtlasSprite texture) {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(texture.getU(this.u)), Float.floatToRawIntBits(texture.getV(this.v)), 0, 0};
        }
    }
}

