/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.function;

import com.dtteam.dynamictrees.registry.DTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class MultiplyCount
extends LootItemConditionalFunction {
    public static final MapCodec<MultiplyCount> CODEC = RecordCodecBuilder.mapCodec(instance -> MultiplyCount.commonFields((RecordCodecBuilder.Instance)instance).and((App)Codec.FLOAT.fieldOf("multiplier").forGetter(c -> Float.valueOf(c.multiplier))).apply((Applicative)instance, MultiplyCount::new));
    private final float multiplier;

    public MultiplyCount(List<LootItemCondition> conditions, float multiplier) {
        super(conditions);
        this.multiplier = multiplier;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return DTRegistries.MULTIPLY_COUNT.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        stack.setCount((int)((float)stack.getCount() * this.multiplier));
        return stack;
    }

    public static LootItemFunction.Builder multiplyCount() {
        return () -> new MultiplyCount(List.of(), 1.0f);
    }
}

