/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.entry;

import com.dtteam.dynamictrees.registry.DTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class WeightedItemLootPoolEntry
extends LootPoolSingletonContainer {
    public static final MapCodec<WeightedItemLootPoolEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SimpleWeightedRandomList.codec((Codec)WeightedEntry.Wrapper.codec((Codec)BuiltInRegistries.ITEM.holderByNameCodec())).fieldOf("items").forGetter(c -> c.items)).and(WeightedItemLootPoolEntry.singletonFields((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, WeightedItemLootPoolEntry::new));
    private final WeightedRandomList<WeightedEntry.Wrapper<Holder<Item>>> items;

    public WeightedItemLootPoolEntry(WeightedRandomList<WeightedEntry.Wrapper<Holder<Item>>> items, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.items = items;
    }

    public LootPoolEntryType getType() {
        return DTRegistries.WEIGHTED_ITEM.get();
    }

    protected void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        this.items.getRandom(lootContext.getRandom()).ifPresent(wrapper -> stackConsumer.accept(new ItemStack((ItemLike)((Holder)wrapper.data()).value())));
    }
}

