/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.item;

import com.dtteam.dynamictrees.api.lazyvalue.LazyValue;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.sapling.PottedSaplingBlock;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.JoCodeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Seed
extends Item {
    private static final LazyValue<RandomSource> BACKUP_RANDOM = LazyValue.supplied(RandomSource::create);
    public static final String FORCE_PLANT_KEY = "ForcePlant";
    public static final String LIFESPAN_KEY = "Lifespan";
    public static final String CODE_KEY = "Code";
    private final Species species;

    public Seed() {
        super(new Item.Properties());
        this.species = Species.NULL_SPECIES;
    }

    public Seed(Species species) {
        this(species, new Item.Properties());
    }

    public Seed(@NotNull Species species, Item.Properties properties) {
        super(properties);
        this.species = species;
        DTRegistries.CREATIVE_TAB_ITEMS.add(this);
    }

    @NotNull
    public Species getSpecies() {
        return this.species;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        int lifespan = Services.INTERACTION.setSeedItemEntityLifespan(entityItem, this);
        if (entityItem.tickCount >= lifespan - 20) {
            Level level = entityItem.level();
            if (!level.isClientSide) {
                ItemStack seedStack = entityItem.getItem();
                BlockPos pos = new BlockPos((Vec3i)entityItem.blockPosition());
                VoluntaryPlantEventResult result = Services.EVENT.postSeedVoluntaryPlantEvent(entityItem, this.getSpecies().selfOrLocationOverride((BlockGetter)level, pos), pos, this.shouldPlant(level, pos, seedStack));
                if (!result.cancelled() && result.willPlant()) {
                    this.doPlanting(level, pos, null, seedStack);
                }
                seedStack.setCount(0);
            }
            entityItem.kill();
        }
        return false;
    }

    public boolean doPlanting(Level level, BlockPos pos, @Nullable Player planter, ItemStack seedStack) {
        Species species = this.getSpecies().selfOrLocationOverride((BlockGetter)level, pos);
        if (species.plantSapling((LevelAccessor)level, pos, this.getSpecies() != species)) {
            String joCode = this.getCode(seedStack, level.random);
            if (!joCode.isEmpty()) {
                level.removeBlock(pos, false);
                BlockPos rootPos = pos.below();
                DynamicTreeGenerationContext context = new DynamicTreeGenerationContext(LevelContext.create((LevelAccessor)level), species, rootPos, rootPos.mutable(), (Holder<Biome>)level.getBiome(pos), planter != null ? planter.getDirection() : Direction.NORTH, 8, false);
                species.getJoCode(joCode).setCareful(true).generate(context);
            }
            return true;
        }
        return false;
    }

    public boolean shouldPlant(Level level, BlockPos pos, ItemStack seedStack) {
        if (this.hasForcePlant(seedStack)) {
            return true;
        }
        if (!level.canSeeSkyFromBelowWater(pos)) {
            return false;
        }
        float plantChance = (float)((double)this.getSpecies().biomeSuitability(level, pos) * Services.CONFIG.getDoubleConfig("seedPlantRate"));
        if (Services.CONFIG.getBoolConfig("seedOnlyForest").booleanValue()) {
            // empty if block
        }
        float accum = 1.0f;
        int count = seedStack.getCount();
        while (count-- > 0) {
            accum *= 1.0f - plantChance;
        }
        plantChance = 1.0f - accum;
        return plantChance > level.random.nextFloat();
    }

    public boolean hasForcePlant(ItemStack seedStack) {
        boolean forcePlant = false;
        return forcePlant;
    }

    public int getTimeToLive(ItemStack seedStack) {
        int lifespan = Services.CONFIG.getIntConfig("seedTimeToLive");
        return lifespan;
    }

    public String getCode(ItemStack seedStack, RandomSource random) {
        String joCode = "";
        return joCode;
    }

    @Nullable
    private JoCode getJoCodeForRadius(RandomSource random, int radius) {
        return JoCodeRegistry.getRandomCode(this.species.getRegistryName(), Mth.clamp((int)radius, (int)2, (int)8), random);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().getFluidState(context.getClickedPos().above()).isEmpty() && this.onItemUsePlantSeed(context, false) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand pHand) {
        BlockHitResult blockhitresult = Seed.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos fluidPos = blockhitresult.getBlockPos();
        if (this.getSpecies().selfOrLocationOverride((BlockGetter)level, fluidPos).isPlantableOnFluid()) {
            ItemStack itemstack = player.getItemInHand(pHand);
            if (blockhitresult.getType() == HitResult.Type.BLOCK && !level.getFluidState(fluidPos).isEmpty() && level.getFluidState(fluidPos.below()).isEmpty() && this.onItemUsePlantSeed(new UseOnContext(player, pHand, blockhitresult), true) == InteractionResult.SUCCESS) {
                return InteractionResultHolder.success((Object)itemstack);
            }
            return InteractionResultHolder.pass((Object)itemstack);
        }
        return super.use(level, player, pHand);
    }

    public InteractionResult onItemUsePlantSeed(UseOnContext context, boolean onFluid) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        BlockPos pos = context.getClickedPos().above(onFluid ? 1 : 0);
        Direction facing = context.getClickedFace();
        if (state.canBeReplaced()) {
            pos = pos.below();
            facing = Direction.UP;
        }
        if (facing == Direction.UP && context.getPlayer() != null && context.getPlayer().mayUseItemAt(pos, facing, context.getItemInHand()) && context.getPlayer().mayUseItemAt(pos.above(), facing, context.getItemInHand()) && this.doPlanting(context.getLevel(), pos.above(), context.getPlayer(), context.getItemInHand())) {
            if (!context.getPlayer().isCreative()) {
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (this.onItemUseFlowerPot(context) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFlowerPot(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState emptyPotState = level.getBlockState(pos = context.getClickedPos());
        Block emptyPotBlock = emptyPotState.getBlock();
        if (!(emptyPotBlock instanceof FlowerPotBlock) || emptyPotState != emptyPotBlock.defaultBlockState() || ((FlowerPotBlock)emptyPotBlock).getPotted() != Blocks.AIR) {
            return InteractionResult.PASS;
        }
        PottedSaplingBlock pottingSapling = this.getSpecies().getPottedSapling();
        level.setBlockAndUpdate(pos, pottingSapling.defaultBlockState());
        if (pottingSapling.setSpecies(level, pos, pottingSapling.defaultBlockState(), this.getSpecies()) && pottingSapling.setPotState(level, emptyPotState, pos)) {
            Player player = context.getPlayer();
            if (player != null) {
                context.getPlayer().awardStat(Stats.POT_FLOWER);
                if (!context.getPlayer().getAbilities().instabuild) {
                    context.getItemInHand().shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public record VoluntaryPlantEventResult(boolean cancelled, boolean willPlant) {
    }
}

