/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.entity.animation;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.entity.animation.AnimationHandler;
import com.dtteam.dynamictrees.entity.animation.DataAnimationHandler;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PhysicsAnimationHandler
implements AnimationHandler {
    @Override
    public String getName() {
        return "physics";
    }

    HandlerData getData(FallingTreeEntity entity) {
        return entity.dataAnimationHandler instanceof HandlerData ? (HandlerData)entity.dataAnimationHandler : new HandlerData();
    }

    protected void playEndSound(FallingTreeEntity entity, boolean onWater) {
        if (!this.getData((FallingTreeEntity)entity).endSoundPlayed && !entity.level().isClientSide()) {
            SoundInstance fallingInstance = this.getData((FallingTreeEntity)entity).fallingSoundInstance;
            if (fallingInstance != null) {
                Minecraft.getInstance().getSoundManager().stop(fallingInstance);
            }
            Species species = entity.getSpecies();
            SoundEvent sound = species.getFallingBranchEndSound(entity.getVolume(), entity.hasLeaves(), onWater);
            entity.playSound(sound, 1.0f, species.getFallingBranchPitch(entity.getVolume()));
            this.getData((FallingTreeEntity)entity).endSoundPlayed = true;
        }
    }

    @Override
    public void initMotion(FallingTreeEntity entity) {
        entity.dataAnimationHandler = new HandlerData();
        BlockPos cutPos = entity.getDestroyData().cutPos;
        long seed = entity.level().random.nextLong();
        RandomSource random = RandomSource.create((long)(seed ^ ((long)cutPos.getX() << 32 | (long)cutPos.getZ())));
        float mass = entity.getDestroyData().woodVolume.getVolume();
        float inertialMass = Mth.clamp((float)mass, (float)1.0f, (float)3.0f);
        entity.setDeltaMovement(entity.getDeltaMovement().x / (double)inertialMass, entity.getDeltaMovement().y / (double)inertialMass, entity.getDeltaMovement().z / (double)inertialMass);
        this.getData((FallingTreeEntity)entity).rotPit = (random.nextFloat() - 0.5f) * 4.0f / inertialMass;
        this.getData((FallingTreeEntity)entity).rotYaw = (random.nextFloat() - 0.5f) * 4.0f / inertialMass;
        double motionToAdd = (double)entity.getDestroyData().cutDir.getOpposite().getStepX() * 0.1;
        entity.setDeltaMovement(entity.getDeltaMovement().add(motionToAdd, motionToAdd, motionToAdd));
        FallingTreeEntity.standardDropLeavesPayLoad(entity);
    }

    @Override
    public void handleMotion(FallingTreeEntity entity) {
        if (entity.landed) {
            return;
        }
        entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y - (double)0.03f, entity.getDeltaMovement().z);
        entity.setDeltaMovement(entity.getDeltaMovement().x * (double)0.98f, entity.getDeltaMovement().y * (double)0.98f, entity.getDeltaMovement().z * (double)0.98f);
        this.getData((FallingTreeEntity)entity).rotYaw *= 0.98f;
        this.getData((FallingTreeEntity)entity).rotPit *= 0.98f;
        entity.setPos(entity.getX() + entity.getDeltaMovement().x, entity.getY() + entity.getDeltaMovement().y, entity.getZ() + entity.getDeltaMovement().z);
        entity.setXRot(Mth.wrapDegrees((float)(entity.getXRot() + this.getData((FallingTreeEntity)entity).rotPit)));
        entity.setYRot(Mth.wrapDegrees((float)(entity.getYRot() + this.getData((FallingTreeEntity)entity).rotYaw)));
        int radius = 8;
        if (entity.getDestroyData().getNumBranches() <= 0) {
            return;
        }
        BlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch(state)) {
            radius = ((BranchBlock)state.getBlock()).getRadius(state);
        }
        Level level = entity.level();
        AABB fallBox = new AABB(entity.getX() - (double)radius, entity.getY(), entity.getZ() - (double)radius, entity.getX() + (double)radius, entity.getY() + 1.0, entity.getZ() + (double)radius);
        BlockPos pos = BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
        BlockState collState = level.getBlockState(pos);
        if (!(TreeHelper.isLeaves(collState) || TreeHelper.isBranch(collState) || collState.getBlock() instanceof TrunkShellBlock)) {
            if (collState.getBlock() instanceof LiquidBlock) {
                this.playEndSound(entity, true);
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, (double)0.03f, 0.0));
                entity.setDeltaMovement(entity.getDeltaMovement().multiply((double)0.8f, (double)0.8f, (double)0.8f));
                this.getData((FallingTreeEntity)entity).rotYaw *= 0.8f;
                this.getData((FallingTreeEntity)entity).rotPit *= 0.8f;
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.01, 0.0));
                entity.onFire = false;
            } else {
                VoxelShape shape = collState.getBlockSupportShape((BlockGetter)level, pos);
                AABB collBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                if (!shape.isEmpty()) {
                    collBox = collState.getBlockSupportShape((BlockGetter)level, pos).bounds();
                }
                if (fallBox.intersects(collBox = collBox.move(pos))) {
                    this.playEndSound(entity, false);
                    entity.setDeltaMovement(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
                    entity.setPos(entity.getX(), collBox.maxY, entity.getZ());
                    entity.yo = entity.getY();
                    entity.landed = true;
                    entity.setOnGround(true);
                    if (entity.onFire && entity.level().isEmptyBlock(pos.above())) {
                        entity.level().setBlockAndUpdate(pos.above(), Blocks.FIRE.defaultBlockState());
                    }
                }
            }
        }
    }

    @Override
    public void dropPayload(FallingTreeEntity entity) {
        Level level = entity.level();
        entity.getPayload().forEach(i -> Block.popResource((Level)level, (BlockPos)BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (ItemStack)i));
        entity.getDestroyData().leavesDrops.forEach(bis -> Block.popResource((Level)level, (BlockPos)entity.getDestroyData().cutPos.offset((Vec3i)bis.pos), (ItemStack)bis.stack));
    }

    @Override
    public boolean shouldDie(FallingTreeEntity entity) {
        boolean dead;
        boolean bl = dead = entity.landed || entity.tickCount > 120;
        if (dead) {
            entity.cleanupRootyDirt();
        }
        return dead;
    }

    @Override
    public void renderTransform(FallingTreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack) {
        float yaw = Mth.wrapDegrees((float)MathUtils.angleDegreesInterpolate(entity.yRotO, entity.getYRot(), partialTick));
        float pit = Mth.wrapDegrees((float)MathUtils.angleDegreesInterpolate(entity.xRotO, entity.getXRot(), partialTick));
        Vec3 mc = entity.getMassCenter();
        poseStack.translate(mc.x, mc.y, mc.z);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pit));
        poseStack.translate(-mc.x - 0.5, -mc.y, -mc.z - 0.5);
    }

    @Override
    public boolean shouldRender(FallingTreeEntity entity, double x, double y, double z) {
        return true;
    }

    static class HandlerData
    extends DataAnimationHandler {
        float rotYaw = 0.0f;
        float rotPit = 0.0f;
        boolean endSoundPlayed = false;
        SoundInstance fallingSoundInstance;

        HandlerData() {
        }
    }
}

