/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.entity.animation;

import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.client.SoundInstanceHandler;
import com.dtteam.dynamictrees.data.tags.DTEntityTypeTags;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.entity.animation.AnimationConstants;
import com.dtteam.dynamictrees.entity.animation.AnimationHandler;
import com.dtteam.dynamictrees.entity.animation.DataAnimationHandler;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class FalloverAnimationHandler
implements AnimationHandler {
    public static final int TICKS_BEFORE_CHECKING_COLLISION = 10;

    @Override
    public String getName() {
        return "fallover";
    }

    HandlerData getData(FallingTreeEntity entity) {
        return entity.dataAnimationHandler != null ? (HandlerData)entity.dataAnimationHandler : new HandlerData();
    }

    protected void playStartSound(FallingTreeEntity entity) {
        if (!this.getData((FallingTreeEntity)entity).startSoundPlayed && entity.level().isClientSide()) {
            Species species = entity.getSpecies();
            SoundEvent sound = species.getFallingTreeStartSound(entity.getVolume(), entity.hasLeaves());
            SoundInstanceHandler.playSoundInstance(sound, species.getFallingTreePitch(entity.getVolume()), entity.position(), entity);
        }
    }

    protected void playEndSound(FallingTreeEntity entity) {
        if (!this.getData((FallingTreeEntity)entity).endSoundPlayed) {
            if (entity.level().isClientSide) {
                SoundInstanceHandler.stopSoundInstance(entity);
            } else {
                Species species = entity.getSpecies();
                SoundEvent sound = species.getFallingTreeEndSound(entity.getVolume(), entity.hasLeaves());
                entity.playSound(sound, 1.5f, species.getFallingTreePitch(entity.getVolume()));
                this.getData((FallingTreeEntity)entity).endSoundPlayed = true;
            }
        }
    }

    protected void playFallThroughWaterSound(FallingTreeEntity entity) {
        if (!this.getData((FallingTreeEntity)entity).fallThroughWaterSoundPlayed && !entity.level().isClientSide()) {
            entity.playSound(entity.getSpecies().getFallingTreeHitWaterSound(entity.getVolume(), entity.hasLeaves()), 2.0f, 1.0f);
            this.getData((FallingTreeEntity)entity).fallThroughWaterSoundPlayed = true;
        }
    }

    private Vec3 rotateAroundAxis(Vec3 in, Vec3 axis, double theta) {
        double x = in.x;
        double y = in.y;
        double z = in.z;
        double u = axis.x;
        double v = axis.y;
        double w = axis.z;
        double v1 = u * x + v * y + w * z;
        double xPrime = u * v1 * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * v1 * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * v1 * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3(xPrime, yPrime, zPrime);
    }

    protected void flingLeavesParticles(FallingTreeEntity entity, float fallSpeed) {
        int bounces = this.getData((FallingTreeEntity)entity).bounces;
        if (bounces > 1) {
            return;
        }
        int maxParticleBlocks = Services.CONFIG.getIntConfig("maxFallingTreeLeavesParticles");
        if (maxParticleBlocks == 0) {
            return;
        }
        BranchDestructionData data = entity.getDestroyData();
        Direction.Axis toolAxis = data.toolDir.getAxis();
        if (toolAxis == Direction.Axis.Y) {
            return;
        }
        double limitChance = 1.0;
        if (data.getNumLeaves() > maxParticleBlocks) {
            limitChance = (double)maxParticleBlocks / (double)data.getNumLeaves();
        }
        limitChance *= Math.exp(-bounces);
        RandomSource rand = entity.level().random;
        int particleCount = (int)((float)(bounces == 0 ? (int)(fallSpeed * 5.0f) : 1) * data.species.falloverParticleFlingMultiplier());
        if (particleCount == 0) {
            return;
        }
        Vec3 angularVel = entity.getForward().scale((double)(fallSpeed * (float)(-data.toolDir.getAxisDirection().getStep())));
        if (toolAxis == Direction.Axis.X) {
            angularVel = new Vec3(angularVel.z, angularVel.x, angularVel.y);
        }
        for (Pair<BlockPos, BlockState> leafLoc : data.getAllLeavesWithPos()) {
            BlockPos leaves = ((BlockPos)leafLoc.getKey()).offset((Vec3i)data.basePos);
            double r = leaves.getY() - data.basePos.getY();
            Vec3 velocity = angularVel.scale(r);
            this.spawnParticlesAtLeaves(entity, leaves, (BlockState)leafLoc.getValue(), velocity, rand, particleCount, limitChance);
        }
    }

    protected void spawnParticlesAtLeaves(FallingTreeEntity entity, BlockPos leavesPos, BlockState leavesState, Vec3 velocity, RandomSource rand, int particleCount, double limitChance) {
        Vec3 newPos = this.getRelativeLeavesPosition(entity, leavesPos.getCenter());
        for (int j = 0; j < particleCount; ++j) {
            if (!(rand.nextDouble() < limitChance) || leavesState == null) continue;
            entity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, leavesState), newPos.x + (double)rand.nextFloat(), newPos.y + (double)rand.nextFloat(), newPos.z + (double)rand.nextFloat(), velocity.x + (double)rand.nextFloat(), velocity.y + (double)rand.nextFloat(), velocity.z + (double)rand.nextFloat());
        }
    }

    protected Vec3 getRelativeLeavesPosition(FallingTreeEntity entity, Vec3 leaves) {
        BranchDestructionData data = entity.getDestroyData();
        float angle = (data.toolDir.getAxis() == Direction.Axis.X ? entity.getYRot() : entity.getXRot()) * (float)(-data.toolDir.getAxisDirection().getStep()) * 0.0174533f;
        return this.rotateAroundAxis(leaves.subtract(data.basePos.getCenter()), new Vec3((double)(-data.toolDir.getStepZ()), 0.0, (double)data.toolDir.getStepX()), angle).add(data.basePos.getCenter()).subtract(0.5, 0.5, 0.5);
    }

    @Override
    public void initMotion(FallingTreeEntity entity) {
        entity.dataAnimationHandler = new HandlerData();
        FallingTreeEntity.standardDropLeavesPayLoad(entity);
        this.playStartSound(entity);
        BlockPos belowBlock = entity.getDestroyData().cutPos.below();
        if (entity.level().getBlockState(belowBlock).isFaceSturdy((BlockGetter)entity.level(), belowBlock, Direction.UP)) {
            entity.setOnGround(true);
        }
    }

    @Override
    public void handleMotion(FallingTreeEntity entity) {
        float fallSpeed = this.getData((FallingTreeEntity)entity).fallSpeed;
        if (entity.onGround()) {
            float height = (float)entity.getMassCenter().y * 2.0f;
            this.addRotation(entity, fallSpeed += (float)(0.2 / (double)height));
        }
        entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y - (double)0.03f, entity.getDeltaMovement().z);
        entity.setPos(entity.getX(), entity.getY() + entity.getDeltaMovement().y, entity.getZ());
        Level level = entity.level();
        int radius = 8;
        BlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch(state)) {
            radius = ((BranchBlock)state.getBlock()).getRadius(state);
        }
        AABB fallBox = new AABB(entity.getX() - (double)radius, entity.getY(), entity.getZ() - (double)radius, entity.getX() + (double)radius, entity.getY() + 1.0, entity.getZ() + (double)radius);
        BlockPos pos = BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
        BlockState collState = level.getBlockState(pos);
        VoxelShape shape = collState.getBlockSupportShape((BlockGetter)level, pos);
        AABB collBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (!shape.isEmpty()) {
            collBox = collState.getBlockSupportShape((BlockGetter)level, pos).bounds();
        }
        if (fallBox.intersects(collBox = collBox.move(pos))) {
            entity.setDeltaMovement(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
            entity.setPos(entity.getX(), collBox.maxY, entity.getZ());
            entity.yo = entity.getY();
            entity.setOnGround(true);
        }
        if (entity.tickCount > 10 && fallSpeed > 0.0f && this.testCollision(entity)) {
            this.playEndSound(entity);
            this.flingLeavesParticles(entity, fallSpeed);
            this.addRotation(entity, -fallSpeed);
            ++this.getData((FallingTreeEntity)entity).bounces;
            entity.landed = Math.abs(fallSpeed *= -0.25f) < 0.02f;
        }
        level = entity.level();
        if (Services.CONFIG.getBoolConfig("enableFallingTreeDamage").booleanValue() && !level.isClientSide) {
            List<LivingEntity> elist = this.testEntityCollision(entity);
            for (LivingEntity living : elist) {
                if (this.getData((FallingTreeEntity)entity).entitiesHit.contains(living) || living.getType().is(DTEntityTypeTags.FALLING_TREE_DAMAGE_IMMUNE)) continue;
                this.getData((FallingTreeEntity)entity).entitiesHit.add(living);
                float damage = entity.getDestroyData().woodVolume.getVolume() * Math.abs(fallSpeed) * 3.0f;
                if (this.getData((FallingTreeEntity)entity).bounces != 0 || !(damage > 2.0f)) continue;
                living.setDeltaMovement(living.getDeltaMovement().x + (double)(level.random.nextFloat() * (float)entity.getDestroyData().toolDir.getOpposite().getStepX() * damage * 0.2f), living.getDeltaMovement().y + (double)(level.random.nextFloat() * fallSpeed * 0.25f), living.getDeltaMovement().z + (double)(level.random.nextFloat() * (float)entity.getDestroyData().toolDir.getOpposite().getStepZ() * damage * 0.2f));
                living.setDeltaMovement(living.getDeltaMovement().x + ((double)level.random.nextFloat() - 0.5), living.getDeltaMovement().y, living.getDeltaMovement().z + ((double)level.random.nextFloat() - 0.5));
                damage = (float)((double)damage * Services.CONFIG.getDoubleConfig("fallingTreeDamageMultiplier"));
                living.hurt(AnimationConstants.treeDamage(level.registryAccess()), damage);
            }
        }
        this.getData((FallingTreeEntity)entity).fallSpeed = fallSpeed;
    }

    private boolean testCollision(FallingTreeEntity entity) {
        Direction toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.getAxis() == Direction.Axis.X ? entity.getYRot() : entity.getXRot();
        int offsetX = toolDir.getStepX();
        int offsetZ = toolDir.getStepZ();
        float h = Mth.sin((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = Mth.cos((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.getX() + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.getY() - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.getZ() + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        trunkHeight = Math.min(trunkHeight, 24);
        for (int segment = 0; segment < trunkHeight; ++segment) {
            float segX = xbase + h * (float)segment * (float)offsetX;
            float segY = ybase + v * (float)segment;
            float segZ = zbase + h * (float)segment * (float)offsetZ;
            float tex = 0.0625f;
            float half = Mth.clamp((float)(tex * (float)(segment + 1) * 2.0f), (float)tex, (float)maxRadius);
            AABB testBB = new AABB((double)(segX - half), (double)(segY - half), (double)(segZ - half), (double)(segX + half), (double)(segY + half), (double)(segZ + half));
            if (entity.level().containsAnyLiquid(testBB)) {
                this.playFallThroughWaterSound(entity);
            }
            if (entity.level().noCollision((Entity)entity, testBB)) continue;
            return true;
        }
        return false;
    }

    private void addRotation(FallingTreeEntity entity, float delta) {
        Direction toolDir = entity.getDestroyData().toolDir;
        switch (toolDir) {
            case NORTH: {
                entity.setXRot(entity.getXRot() + delta);
                break;
            }
            case SOUTH: {
                entity.setXRot(entity.getXRot() - delta);
                break;
            }
            case WEST: {
                entity.setYRot(entity.getYRot() + delta);
                break;
            }
            case EAST: {
                entity.setYRot(entity.getYRot() - delta);
                break;
            }
        }
        entity.setXRot(Mth.wrapDegrees((float)entity.getXRot()));
        entity.setYRot(Mth.wrapDegrees((float)entity.getYRot()));
    }

    public List<LivingEntity> testEntityCollision(FallingTreeEntity entity) {
        Level level = entity.level();
        Direction toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.getAxis() == Direction.Axis.X ? entity.getYRot() : entity.getXRot();
        int offsetX = toolDir.getStepX();
        int offsetZ = toolDir.getStepZ();
        float h = Mth.sin((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = Mth.cos((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.getX() + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.getY() - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.getZ() + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float segX = xbase + h * (float)(trunkHeight - 1) * (float)offsetX;
        float segY = ybase + v * (float)(trunkHeight - 1);
        float segZ = zbase + h * (float)(trunkHeight - 1) * (float)offsetZ;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        Vec3 vec3d1 = new Vec3((double)xbase, (double)ybase, (double)zbase);
        Vec3 vec3d2 = new Vec3((double)segX, (double)segY, (double)segZ);
        return level.getEntities((Entity)entity, new AABB(vec3d1.x, vec3d1.y, vec3d1.z, vec3d2.x, vec3d2.y, vec3d2.z), entity1 -> {
            if (entity1 instanceof LivingEntity && entity1.isPickable()) {
                AABB axisalignedbb = entity1.getBoundingBox().inflate((double)maxRadius);
                return axisalignedbb.contains(vec3d1) || FalloverAnimationHandler.intersects(axisalignedbb, vec3d1, vec3d2);
            }
            return false;
        }).stream().map(a -> (LivingEntity)a).collect(Collectors.toList());
    }

    public static boolean intersects(AABB axisAlignedBB, Vec3 vec3d, Vec3 otherVec3d) {
        return axisAlignedBB.intersects(Math.min(vec3d.x, otherVec3d.x), Math.min(vec3d.y, otherVec3d.y), Math.min(vec3d.z, otherVec3d.z), Math.max(vec3d.x, otherVec3d.x), Math.max(vec3d.y, otherVec3d.y), Math.max(vec3d.z, otherVec3d.z));
    }

    @Override
    public void dropPayload(FallingTreeEntity entity) {
        Level level = entity.level();
        BlockPos cutPos = entity.getDestroyData().cutPos;
        entity.getPayload().forEach(i -> Block.popResource((Level)level, (BlockPos)cutPos, (ItemStack)i));
    }

    @Override
    public boolean shouldDie(FallingTreeEntity entity) {
        boolean dead;
        boolean bl = dead = Math.abs(entity.getXRot()) >= 160.0f || Math.abs(entity.getYRot()) >= 160.0f || entity.landed || entity.tickCount > 120 + entity.getDestroyData().trunkHeight;
        if (dead) {
            entity.cleanupRootyDirt();
            if (entity.level().isClientSide) {
                SoundInstanceHandler.stopSoundInstance(entity);
            }
        }
        return dead;
    }

    @Override
    public void renderTransform(FallingTreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack) {
        float yaw = Mth.wrapDegrees((float)MathUtils.angleDegreesInterpolate(entity.yRotO, entity.getYRot(), partialTick));
        float pit = Mth.wrapDegrees((float)MathUtils.angleDegreesInterpolate(entity.xRotO, entity.getXRot(), partialTick));
        int radius = entity.getDestroyData().getBranchRadius(0);
        Direction toolDir = entity.getDestroyData().toolDir;
        Vec3 toolVec = new Vec3((double)toolDir.getStepX(), (double)toolDir.getStepY(), (double)toolDir.getStepZ()).scale((double)((float)radius / 16.0f));
        poseStack.translate(-toolVec.x, -toolVec.y, -toolVec.z);
        poseStack.mulPose(Axis.ZN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pit));
        poseStack.translate(toolVec.x, toolVec.y, toolVec.z);
        poseStack.translate(-0.5, 0.0, -0.5);
    }

    @Override
    public boolean shouldRender(FallingTreeEntity entity, double x, double y, double z) {
        return true;
    }

    static class HandlerData
    extends DataAnimationHandler {
        float fallSpeed = 0.0f;
        int bounces = 0;
        boolean startSoundPlayed = false;
        boolean fallThroughWaterSoundPlayed = false;
        boolean endSoundPlayed = false;
        HashSet<LivingEntity> entitiesHit = new HashSet();

        HandlerData() {
        }
    }
}

