/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer.worldgen;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonMath;
import com.dtteam.dynamictrees.deserialization.deserializer.worldgen.JsonBiomeDatabaseDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class ChanceSelectorDeserializer
implements JsonBiomeDatabaseDeserializer<BiomePropertySelectors.ChanceSelector> {
    @Override
    public Result<BiomePropertySelectors.ChanceSelector, JsonElement> deserialize(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(JsonObject.class, this::readChanceSelector).elseMapIfType(Float.class, this::createSimpleChanceSelector).elseMapIfType(String.class, name -> {
            if (name.equalsIgnoreCase("standard")) {
                return (rnd, spc, rad) -> rnd.nextFloat() < (rad > 3 ? 2.0f / (float)rad : 1.0f) ? BiomePropertySelectors.Chance.OK : BiomePropertySelectors.Chance.CANCEL;
            }
            throw new DeserializationException("Unrecognised named chance selector \"" + name + "\".");
        }).elseTypeError();
    }

    private BiomePropertySelectors.ChanceSelector createSimpleChanceSelector(float value) {
        if (value <= 0.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.Chance.CANCEL;
        }
        if (value >= 1.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.Chance.OK;
        }
        return (rnd, spc, rad) -> rnd.nextFloat() < value ? BiomePropertySelectors.Chance.OK : BiomePropertySelectors.Chance.CANCEL;
    }

    @Nullable
    private BiomePropertySelectors.ChanceSelector readChanceSelector(JsonObject jsonObject, Consumer<String> warningConsumer) throws DeserializationException {
        return (BiomePropertySelectors.ChanceSelector)JsonResult.forInput((JsonElement)jsonObject).mapIfContains("static", JsonElement.class, input -> JsonResult.forInput(input).mapIfType(Float.class, this::createSimpleChanceSelector).elseMapIfType(String.class, name -> {
            if (this.isDefault((String)name)) {
                return (rnd, spc, rad) -> BiomePropertySelectors.Chance.UNHANDLED;
            }
            throw new DeserializationException("Unrecognised named chance selector \"" + name + "\".");
        }).elseTypeError()).elseMapIfContains("math", JsonElement.class, input -> JsonResult.forInput(input).map(element -> {
            JsonMath jsonMath = new JsonMath((JsonElement)input);
            return (rnd, spc, rad) -> rnd.nextFloat() < jsonMath.apply(rnd, spc, rad) ? BiomePropertySelectors.Chance.OK : BiomePropertySelectors.Chance.CANCEL;
        })).map(result -> {
            result.getWarnings().forEach(warningConsumer);
            return (BiomePropertySelectors.ChanceSelector)result.orElseThrow();
        }).orElseThrow();
    }
}

