/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.phys.shapes.BooleanOp;

public final class BooleanOpDeserializer
implements JsonDeserializer<BooleanOp> {
    private static final Map<String, BooleanOp> VALUES = (Map)Util.make((Object)Maps.newHashMap(), values -> {
        values.put("false", BooleanOp.FALSE);
        values.put("not_or", BooleanOp.NOT_OR);
        values.put("only_second", BooleanOp.ONLY_SECOND);
        values.put("not_first", BooleanOp.NOT_FIRST);
        values.put("only_first", BooleanOp.ONLY_FIRST);
        values.put("not_second", BooleanOp.NOT_SECOND);
        values.put("not_same", BooleanOp.NOT_SAME);
        values.put("not_and", BooleanOp.NOT_AND);
        values.put("and", BooleanOp.AND);
        values.put("same", BooleanOp.SAME);
        values.put("second", BooleanOp.SECOND);
        values.put("causes", BooleanOp.CAUSES);
        values.put("first", BooleanOp.FIRST);
        values.put("caused_by", BooleanOp.CAUSED_BY);
        values.put("or", BooleanOp.OR);
        values.put("true", BooleanOp.TRUE);
    });

    @Override
    public Result<BooleanOp, JsonElement> deserialize(JsonElement input) {
        return JsonDeserializers.STRING.deserialize(input).map(VALUES::get);
    }
}

