/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.applier;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.dtteam.dynamictrees.utility.NullUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ArrayIteratorPropertyApplier<T, V, I>
extends PropertyApplier<T, V, I> {
    private final PropertyApplier<T, V, I> propertyApplier;
    private final Function<I, Result<Iterator<I>, I>> iteratorDeserialiser;

    public ArrayIteratorPropertyApplier(String key, Class<T> objectClass, Class<V> valueClass, PropertyApplier<T, V, I> applier, Function<I, Result<Iterator<I>, I>> iteratorDeserialiser) {
        super(key, objectClass, applier.applier);
        this.propertyApplier = applier;
        this.iteratorDeserialiser = iteratorDeserialiser;
    }

    @Override
    @Deprecated
    @Nullable
    protected PropertyApplierResult applyIfShould(T object, I input, Applier<T, V> applier) {
        Result<Iterator<I>, I> iteratorResult = this.iteratorDeserialiser.apply(input);
        if (!iteratorResult.success()) {
            return null;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        Iterator<I> iterator = iteratorResult.get();
        while (iterator.hasNext()) {
            NullUtils.consumeIfNonnull(this.propertyApplier.applyIfShould(object, iterator.next(), applier), result -> {
                result.getError().ifPresent(warnings::add);
                warnings.addAll(result.getWarnings());
            });
        }
        return PropertyApplierResult.success(warnings);
    }

    public static <T, V> ArrayIteratorPropertyApplier<T, V, JsonElement> json(String key, Class<T> objectClass, Class<V> valueClass, PropertyApplier<T, V, JsonElement> applier) {
        return new ArrayIteratorPropertyApplier<T, V, JsonElement>(key, objectClass, valueClass, applier, element -> JsonDeserializers.JSON_ARRAY.deserialize(element).map(JsonArray::iterator));
    }
}

