/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.provider;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class DTBlockTagsProvider
extends BlockTagsProvider {
    public DTBlockTagsProvider(PackOutput output, String modid, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper fileHelper) {
        super(output, lookupProvider, modid, fileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        if (this.modId.equals("dynamictrees")) {
            this.addDTOnlyTags();
        }
        this.addDTTags();
    }

    private void addDTOnlyTags() {
        this.tag(DTBlockTags.BRANCHES).addTag(DTBlockTags.BRANCHES_THAT_BURN).addTag(DTBlockTags.FUNGUS_BRANCHES);
        this.tag(DTBlockTags.FOLIAGE).add((Object)Blocks.SHORT_GRASS).add((Object)Blocks.TALL_GRASS).add((Object)Blocks.FERN).add((Object)Blocks.LILY_PAD).add((Object)Blocks.PINK_PETALS).add((Object)Blocks.BROWN_MUSHROOM).add((Object)Blocks.RED_MUSHROOM).add((Object)Blocks.MOSS_CARPET).addTag(BlockTags.FLOWERS).addTag(BlockTags.REPLACEABLE_BY_TREES);
        this.tag(DTBlockTags.STRIPPED_BRANCHES).addTag(DTBlockTags.STRIPPED_BRANCHES_THAT_BURN).addTag(DTBlockTags.STRIPPED_FUNGUS_BRANCHES);
        this.tag(BlockTags.ENDERMAN_HOLDABLE).addTag(DTBlockTags.FUNGUS_CAPS);
        this.tag(BlockTags.FLOWER_POTS).add((Object)((Block)DTRegistries.POTTED_SAPLING.get()));
        ((Species)Species.REGISTRY.get(DynamicTrees.WARPED)).getSapling().ifPresent(sapling -> this.tag(BlockTags.HOGLIN_REPELLENTS).add((Object)sapling));
        this.tag(BlockTags.LEAVES).addTag(DTBlockTags.LEAVES);
        this.tag(BlockTags.LOGS).addTag(DTBlockTags.BRANCHES);
        this.tag(BlockTags.LOGS_THAT_BURN).addTag(DTBlockTags.BRANCHES_THAT_BURN).addTag(DTBlockTags.STRIPPED_BRANCHES_THAT_BURN);
        this.tag(BlockTags.SAPLINGS).addTag(DTBlockTags.SAPLINGS);
        this.tag(BlockTags.WART_BLOCKS).addTag(DTBlockTags.WART_BLOCKS);
        this.tag(BlockTags.MINEABLE_WITH_AXE).addTag(DTBlockTags.ROOTS).addTag(DTBlockTags.AERIAL_ROOTS_ROOTY_SOIL);
    }

    protected void addDTTags() {
        LeavesProperties.REGISTRY.dataGenerationStream(this.modId).forEach(leavesProperties -> leavesProperties.addGeneratedBlockTags(x$0 -> this.tag((TagKey)x$0)));
        Family.REGISTRY.dataGenerationStream(this.modId).forEach(family -> family.addGeneratedBlockTags(x$0 -> this.tag((TagKey)x$0)));
        Species.REGISTRY.dataGenerationStream(this.modId).forEach(species -> species.addGeneratedBlockTags(x$0 -> this.tag((TagKey)x$0)));
        SoilProperties.REGISTRY.dataGenerationStream(this.modId).forEach(soilProperties -> soilProperties.addGeneratedBlockTags(x$0 -> this.tag((TagKey)x$0)));
    }

    public String getName() {
        return this.modId + " DT Block Tags";
    }
}

