/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class DirtBucketRecipeHandler {
    public static void registerDirtBucketRecipes(Collection<RecipeHolder<?>> craftingRecipes) {
        for (Species species : Species.REGISTRY.getAll()) {
            if (!species.hasSeed()) continue;
            ResourceLocation registryName = species.getRegistryName();
            species.getPrimitiveSaplingRecipes().forEach(saplingRecipe -> {
                List<Item> ingredients;
                Item saplingItem = saplingRecipe.getSaplingItem().orElse(null);
                if (saplingItem == null) {
                    DynamicTrees.LOG.error("Error creating seed-sapling recipe for species \"{}\" as sapling item does not exist.", (Object)species.getRegistryName());
                    return;
                }
                BuiltInRegistries.ITEM.getKey((Object)saplingItem);
                if (saplingRecipe.canCraftSaplingToSeed()) {
                    ResourceLocation saplingToSeed = ResourceLocation.fromNamespaceAndPath((String)registryName.getNamespace(), (String)(DirtBucketRecipeHandler.separate(BuiltInRegistries.ITEM.getKey((Object)saplingItem)) + "_to_" + registryName.getPath() + "_seed"));
                    ingredients = saplingRecipe.getIngredientsForSaplingToSeed();
                    ingredients.add(DTRegistries.DIRT_BUCKET.get());
                    ingredients.add(saplingItem);
                    craftingRecipes.add(new RecipeHolder(saplingToSeed, (Recipe)DirtBucketRecipeHandler.createShapeless(saplingToSeed, species.getSeedStack(1), DirtBucketRecipeHandler.ingredients(ingredients))));
                }
                if (saplingRecipe.canCraftSeedToSapling()) {
                    ResourceLocation seedToSapling = ResourceLocation.fromNamespaceAndPath((String)registryName.getNamespace(), (String)(registryName.getPath() + "_seed_to_" + DirtBucketRecipeHandler.separate(BuiltInRegistries.ITEM.getKey((Object)saplingItem))));
                    ingredients = saplingRecipe.getIngredientsForSeedToSapling();
                    ingredients.add(DTRegistries.DIRT_BUCKET.get());
                    ingredients.add(species.getSeed().map(Item.class::cast).orElse(Items.AIR));
                    craftingRecipes.add(new RecipeHolder(seedToSapling, (Recipe)DirtBucketRecipeHandler.createShapeless(seedToSapling, new ItemStack((ItemLike)saplingItem), DirtBucketRecipeHandler.ingredients(ingredients))));
                }
            });
        }
    }

    private static String separate(ResourceLocation resourceLocation) {
        return resourceLocation.getNamespace() + "_" + resourceLocation.getPath();
    }

    private static ShapelessRecipe createShapeless(ResourceLocation registryName, ItemStack out, Ingredient ... ingredients) {
        return new ShapelessRecipe("CRAFTING_MISC", CraftingBookCategory.MISC, out, NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
    }

    private static Ingredient[] ingredients(Collection<Item> items) {
        return DirtBucketRecipeHandler.ingredients(items.toArray(new Item[0]));
    }

    private static Ingredient[] ingredients(Item ... items) {
        if (items.length == 0) {
            return new Ingredient[]{Ingredient.EMPTY};
        }
        return Arrays.stream(items).map(item -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)})).collect(Collectors.toSet()).toArray(new Ingredient[0]);
    }
}

