/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data;

import com.dtteam.dynamictrees.loot.DTLootParameterSets;
import com.dtteam.dynamictrees.loot.condition.SeasonalSeedDropChance;
import com.dtteam.dynamictrees.loot.condition.VoluntarySeedDropChance;
import com.dtteam.dynamictrees.loot.entry.SeedItemLootPoolEntry;
import com.dtteam.dynamictrees.loot.function.MultiplyByLogsCount;
import com.dtteam.dynamictrees.loot.function.MultiplyBySticksCount;
import com.dtteam.dynamictrees.utility.ItemUtils;
import java.util.List;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class DTLootTableBuilder {
    protected static LootItemCondition.Builder hasSilkTouch(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup registrylookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    private static LootItemCondition.Builder hasNoShearsOrSilkTouch(HolderLookup.Provider registries) {
        return DTLootTableBuilder.hasShearsOrSilkTouch(registries).invert();
    }

    private static LootItemCondition.Builder hasShearsOrSilkTouch(HolderLookup.Provider registries) {
        LootItemCondition.Builder hasShears = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
        return hasShears.or(DTLootTableBuilder.hasSilkTouch(registries));
    }

    protected static LootTable.Builder createSelfDropDispatchTable(Block block, LootItemCondition.Builder conditionBuilder, LootPoolEntryContainer.Builder<?> alternativeBuilder) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(conditionBuilder)).otherwise(alternativeBuilder)));
    }

    public static LootTable.Builder createLeavesBlockDrops(Block primitiveLeavesBlock, float[] seedChances, Item stickItem, HolderLookup.Provider registries) {
        return DTLootTableBuilder.createSelfDropDispatchTable(primitiveLeavesBlock, DTLootTableBuilder.hasShearsOrSilkTouch(registries), ((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])seedChances))).when(SeasonalSeedDropChance.seasonalSeedDropChance())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(DTLootTableBuilder.hasNoShearsOrSilkTouch(registries)).add(LootItem.lootTableItem((ItemLike)stickItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).setParamSet(LootContextParamSets.BLOCK);
    }

    public static LootTable.Builder createPalmLeavesBlockDrops(Block primitiveLeavesBlock, float[] seedChances, HolderLookup.Provider registries) {
        return DTLootTableBuilder.createSelfDropDispatchTable(primitiveLeavesBlock, DTLootTableBuilder.hasShearsOrSilkTouch(registries), ((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])seedChances))).when(SeasonalSeedDropChance.seasonalSeedDropChance())).setParamSet(LootContextParamSets.BLOCK);
    }

    public static LootTable.Builder createWartBlockDrops(Block primitiveWartBlock, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)primitiveWartBlock)).when(ExplosionCondition.survivesExplosion()));
    }

    public static LootTable.Builder createLeavesDrops(float[] seedChances, LootContextParamSet parameterSet, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])seedChances))).when(SeasonalSeedDropChance.seasonalSeedDropChance()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).setParamSet(parameterSet);
    }

    public static LootTable.Builder createPalmLeavesDrops(float[] seedChances, LootContextParamSet parameterSet, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])seedChances))).when(SeasonalSeedDropChance.seasonalSeedDropChance()))).setParamSet(parameterSet);
    }

    public static LootTable.Builder createWartDrops(Block primitiveWartBlock, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)primitiveWartBlock)).when(ExplosionCondition.survivesExplosion()).when(BonusLevelTableCondition.bonusLevelFlatChance(ItemUtils.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, registries), (float[])new float[]{0.1f, 0.1333333f, 0.1666666f, 0.2f})));
    }

    public static LootTable.Builder createVoluntaryDrops(Item seedItem, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)seedItem).when(VoluntarySeedDropChance.voluntarySeedDropChance()))).setParamSet(DTLootParameterSets.VOLUNTARY);
    }

    public static LootTable.Builder createBranchDrops(Block primitiveLogBlock, Item stickItem, HolderLookup.Provider registries) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)primitiveLogBlock).apply(MultiplyByLogsCount.multiplyByLogsCount()).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)stickItem).apply(MultiplyBySticksCount.multiplyBySticksCount()).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))).setParamSet(DTLootParameterSets.BRANCHES);
    }

    public static LootTable.Builder createFruitPodDrops(Block fruitBlock, Item fruitItem, IntegerProperty ageProperty, int matureAge, int count, HolderLookup.Provider registries) {
        return DTLootTableBuilder.createFruitPodDrops(fruitBlock, fruitItem, ageProperty, matureAge, count, count, registries);
    }

    public static LootTable.Builder createFruitPodDrops(Block fruitBlock, Item fruitItem, IntegerProperty ageProperty, int matureAge, int countMin, int countMax, HolderLookup.Provider registries) {
        ConstantValue numberProvider = countMin == countMax ? ConstantValue.exactly((float)countMax) : UniformGenerator.between((float)countMin, (float)countMax);
        LootPoolSingletonContainer.Builder itemBuilder = LootItem.lootTableItem((ItemLike)fruitItem);
        if (countMin != countMax || countMax != 1) {
            itemBuilder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)numberProvider));
            if (countMin < 0) {
                itemBuilder.apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0)));
            }
        }
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(itemBuilder.apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)fruitBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ageProperty, matureAge))))).setParamSet(LootContextParamSets.BLOCK);
    }
}

