/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.command.subcommand;

import com.dtteam.dynamictrees.api.registry.Registry;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.command.subcommand.SubCommand;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class RegistrySubCommand<V extends RegistryEntry<V>>
extends SubCommand {
    public final Registry<V> registry;

    public RegistrySubCommand(Registry<V> registry) {
        this.registry = registry;
    }

    @Override
    protected String getName() {
        return this.registry.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    protected int getPermissionLevel() {
        return 0;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> RegistrySubCommand.executesSuccess(() -> this.listEntries((CommandSourceStack)context.getSource(), false)))).then(RegistrySubCommand.booleanArgument("raw").executes(context -> RegistrySubCommand.executesSuccess(() -> this.listEntries((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"raw")))));
    }

    private void listEntries(CommandSourceStack source, boolean raw) {
        if (raw) {
            this.registry.getAll().forEach(entry -> source.sendSuccess(() -> Component.literal((String)entry.getRegistryName().toString()), false));
            return;
        }
        this.registry.getAll().forEach(entry -> source.sendSuccess(() -> Component.literal((String)"- ").append(entry.getTextComponent()).withStyle(ChatFormatting.GREEN), false));
    }
}

