/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.soil;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.platform.Services;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaterSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(WaterSoilProperties::new);

    public WaterSoilProperties(ResourceLocation registryName) {
        super(null, registryName);
        this.soilStateGenerator.reset((Supplier)blockStateGenerators.get(DynamicTrees.location("water_root_soil")));
    }

    @Override
    protected SoilBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new SoilWaterBlock(this, blockProperties);
    }

    @Override
    public MapColor getDefaultMapColor() {
        return MapColor.WATER;
    }

    @Override
    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER);
    }

    public static class SoilWaterBlock
    extends SoilBlock
    implements SimpleWaterloggedBlock {
        protected static final AABB WATER_ROOTS_AABB = new AABB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

        public SoilWaterBlock(SoilProperties properties, BlockBehaviour.Properties blockProperties) {
            super(properties, blockProperties);
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{WATERLOGGED}));
        }

        @Override
        public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
            return 1;
        }

        @Override
        public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
            return (float)(0.5 * Services.CONFIG.getDoubleConfig("rootyBlockHardnessMultiplier"));
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Shapes.create((AABB)WATER_ROOTS_AABB);
        }

        public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
            return Shapes.empty();
        }

        public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
            return false;
        }

        public FluidState getFluidState(BlockState state) {
            return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
        }

        public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
        }

        @Override
        public BlockState getDecayBlockState(BlockState state, BlockGetter level, BlockPos pos) {
            if (state.hasProperty((Property)WATERLOGGED) && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                return Blocks.AIR.defaultBlockState();
            }
            return super.getDecayBlockState(state, level, pos);
        }

        @Override
        public boolean getColorFromBark() {
            return true;
        }

        @Override
        public boolean fallWithTree(BlockState state, Level level, BlockPos pos) {
            level.setBlockAndUpdate(pos, this.getDecayBlockState(state, (BlockGetter)level, pos));
            return true;
        }
    }
}

