/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.soil;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.client.ParticleHelper;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SpreadableSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(SpreadableSoilProperties::new);
    private Integer required_light = null;
    private Item spread_item = null;
    private final List<SoilProperties> spreadable_soils = new LinkedList<SoilProperties>();

    public void setRequiredLight(Integer light) {
        this.required_light = light;
    }

    public void setSpreadItem(Item item) {
        this.spread_item = item;
    }

    public SpreadableSoilProperties(ResourceLocation registryName) {
        super(null, registryName);
    }

    @Override
    protected SoilBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new SpreadableSoilBlock(this, blockProperties);
    }

    public void addSpreadableSoils(Block ... blocks) {
        for (Block block : blocks) {
            SoilProperties props = SoilHelper.getProperties(block);
            if (!props.isValid()) continue;
            this.spreadable_soils.add(props);
        }
    }

    public void addSpreadableSoils(SoilProperties ... props) {
        this.spreadable_soils.addAll(Arrays.asList(props));
    }

    public static class SpreadableSoilBlock
    extends SoilBlock {
        public SpreadableSoilBlock(SpreadableSoilProperties properties, BlockBehaviour.Properties blockProperties) {
            super(properties, blockProperties);
        }

        @Override
        public SpreadableSoilProperties getSoilProperties() {
            return (SpreadableSoilProperties)super.getSoilProperties();
        }

        private Optional<SoilBlock> getRootyBlock(Block block) {
            return SoilHelper.getProperties(block).getBlock();
        }

        @Override
        protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            ItemStack handStack;
            SpreadableSoilProperties properties = this.getSoilProperties();
            if (properties.spread_item != null && (handStack = player.getItemInHand(hand)).getItem().equals(properties.spread_item)) {
                LinkedList<Block> foundBlocks = new LinkedList<Block>();
                for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                    Block block = level.getBlockState(blockpos).getBlock();
                    if (!properties.spreadable_soils.stream().anyMatch(prop -> prop.getPrimitiveSoilBlock() == block)) continue;
                    foundBlocks.add(block);
                }
                if (!foundBlocks.isEmpty()) {
                    if (!level.isClientSide()) {
                        int blockInt = level.random.nextInt(foundBlocks.size());
                        this.getRootyBlock((Block)foundBlocks.get(blockInt)).ifPresent(rootyBlock -> level.setBlock(pos, rootyBlock.defaultBlockState(), 3));
                    }
                    if (!player.isCreative()) {
                        handStack.shrink(1);
                    }
                    ParticleHelper.spawnParticles(level, ParticleTypes.HAPPY_VILLAGER, pos.above(), 2 + level.random.nextInt(5), level.random);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }

        @Override
        public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            super.randomTick(state, level, pos, random);
            SpreadableSoilProperties properties = this.getSoilProperties();
            if (!level.isClientSide && properties.required_light != null) {
                if (!ChunkTreeHelper.canCheckSurroundings((LevelAccessor)level, pos, 3)) {
                    return;
                }
                if (level.getMaxLocalRawBrightness(pos.above()) >= properties.required_light) {
                    for (int i = 0; i < 4; ++i) {
                        BlockPos thatPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                        if (thatPos.getY() >= 0 && thatPos.getY() < 256 && !level.hasChunkAt(thatPos)) {
                            return;
                        }
                        BlockState thatStateUp = level.getBlockState(thatPos.above());
                        BlockState thatState = level.getBlockState(thatPos);
                        for (SoilProperties spreadable : properties.spreadable_soils) {
                            SoilBlock block = spreadable.getBlock().orElse(null);
                            if (block == null || thatState.getBlock() != spreadable.getPrimitiveSoilBlock() && thatState.getBlock() != block || level.getMaxLocalRawBrightness(pos.above()) < properties.required_light || thatStateUp.getLightBlock((BlockGetter)level, thatPos.above()) > 2) continue;
                            if (state.hasProperty((Property)FERTILITY)) {
                                level.setBlockAndUpdate(pos, (BlockState)block.defaultBlockState().setValue((Property)FERTILITY, (Comparable)((Integer)state.getValue((Property)FERTILITY))));
                            }
                            return;
                        }
                    }
                }
            }
        }
    }
}

