/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.leaves;

import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.Ageable;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.client.ParticleHelper;
import com.dtteam.dynamictrees.data.tags.DTEntityTypeTags;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DynamicLeavesBlock
extends LeavesBlock
implements TreePart,
Ageable {
    public LeavesProperties properties = LeavesProperties.NULL;
    protected static final VoxelShape SUPPORT_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)DynamicLeavesBlock.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public DynamicLeavesBlock(LeavesProperties leavesProperties, BlockBehaviour.Properties properties) {
        this(properties);
        this.setProperties(leavesProperties);
        leavesProperties.setDynamicLeavesState(this.defaultBlockState());
    }

    public DynamicLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void setProperties(LeavesProperties properties) {
        this.properties = properties;
    }

    public LeavesProperties getLeavesProperties() {
        return this.properties;
    }

    @Override
    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLeavesProperties().getFamily();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getLeavesProperties().getFlammability();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getLeavesProperties().getFireSpreadSpeed();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return this.getLeavesProperties().getPrimitiveLeaves().getDestroyProgress(player, level, pos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.getLeavesProperties().getPrimitiveLeavesItemStack();
    }

    @Override
    public int age(LevelAccessor level, BlockPos pos, BlockState state, RandomSource rand, boolean worldgen) {
        return this.updateLeaves(level, pos, state, rand, worldgen);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        double growthMultiplier = Services.CONFIG.getDoubleConfig("treeGrowthMultiplier");
        if ((double)rand.nextFloat() > growthMultiplier) {
            return;
        }
        if (this.removeIfInvalid(state, (LevelAccessor)level, pos, rand)) {
            return;
        }
        if ((double)rand.nextFloat() < 0.01) {
            this.age((LevelAccessor)level, pos, state, rand, false);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        int sideHydro;
        BlockState neighborState = level.getBlockState(neighborPos);
        boolean sideIsLeaves = neighborState.hasProperty((Property)DISTANCE);
        int n = sideHydro = sideIsLeaves ? (Integer)neighborState.getValue((Property)DISTANCE) : 0;
        if (!sideIsLeaves || sideHydro < (Integer)state.getValue((Property)DISTANCE)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        this.updateHydro((LevelAccessor)level, pos, state, false);
    }

    public boolean updateAllLeaves(LevelAccessor level, BlockPos startPos, BlockState startState, RandomSource rand, boolean worldGen) {
        ArrayDeque<Tuple> toProcess = new ArrayDeque<Tuple>();
        HashSet<BlockPos> processedPositions = new HashSet<BlockPos>();
        int firstHydro = this.updateHydro(level, startPos, startState, worldGen);
        toProcess.add(new Tuple((Object)startPos, (Object)firstHydro));
        if (firstHydro == 0) {
            return false;
        }
        while (!toProcess.isEmpty() && processedPositions.size() <= this.getLeavesProperties().maxLeavesRecursion()) {
            Tuple tup = (Tuple)toProcess.remove();
            BlockPos pos = (BlockPos)tup.getA();
            int hydro = (Integer)tup.getB();
            processedPositions.add(pos);
            for (Direction dir : Direction.values()) {
                BlockState sideState;
                boolean hasLeaves;
                int sideHydro;
                BlockPos sidePos;
                if (hydro <= 1 && rand.nextInt(4) != 0 || processedPositions.contains(sidePos = pos.relative(dir)) || (sideHydro = (hasLeaves = TreeHelper.isLeaves(sideState = level.getBlockState(sidePos))) ? this.updateHydro(level, sidePos, sideState, worldGen) : this.growLeavesIfLocationIsSuitable(level, this.getLeavesProperties(), sidePos, null)) != 0 && sideHydro > hydro) continue;
                toProcess.add(new Tuple((Object)sidePos, (Object)sideHydro));
            }
        }
        return true;
    }

    public int updateLeaves(LevelAccessor level, BlockPos pos, BlockState state, RandomSource rand, boolean worldGen) {
        int newHydro = this.updateHydro(level, pos, state, worldGen);
        if (newHydro == 0) {
            return 0;
        }
        if (!worldGen && this.removeIfInvalid(state, level, pos, rand)) {
            return 0;
        }
        for (Direction dir : Direction.values()) {
            if (newHydro <= 1 && rand.nextInt(4) != 0) continue;
            BlockPos sidePos = pos.relative(dir);
            this.growLeavesIfLocationIsSuitable(level, this.getLeavesProperties(), sidePos, null);
        }
        return newHydro;
    }

    public int updateHydro(LevelAccessor accessor, BlockPos pos, BlockState state, boolean worldGen) {
        LeavesProperties leavesProperties = this.getLeavesProperties();
        int oldHydro = (Integer)state.getValue((Property)DISTANCE);
        if (!ChunkTreeHelper.canCheckSurroundings(accessor, pos, 2)) {
            return oldHydro;
        }
        int newHydro = this.getHydrationLevelFromNeighbors(accessor, pos, leavesProperties);
        if (oldHydro != newHydro) {
            boolean decayed;
            BlockState placeState = this.getLeavesBlockStateForPlacement(accessor, pos, leavesProperties.getDynamicLeavesState(newHydro), oldHydro, worldGen);
            boolean bl = decayed = newHydro == 0;
            int flag = decayed ? 3 : (this.appearanceChangesWithHydro(oldHydro, newHydro) ? 2 : 4);
            accessor.setBlock(pos, placeState, flag);
        }
        return newHydro;
    }

    public boolean appearanceChangesWithHydro(int oldHydro, int newHydro) {
        return false;
    }

    public BlockState getLeavesBlockStateForPlacement(LevelAccessor level, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
        return leavesStateWithHydro;
    }

    public int growLeavesIfLocationIsSuitable(LevelAccessor level, LeavesProperties leavesProp, BlockPos pos, @Nullable Integer hydro) {
        if (this.isLocationSuitableForNewLeaves(level, leavesProp, pos)) {
            hydro = hydro == null ? Integer.valueOf(this.getHydrationLevelFromNeighbors(level, pos, leavesProp)) : Integer.valueOf(hydro == 0 ? leavesProp.getCellKit().getDefaultHydration() : hydro.intValue());
            level.setBlock(pos, this.getLeavesBlockStateForPlacement(level, pos, leavesProp.getDynamicLeavesState(hydro), 0, false), 2);
            return hydro;
        }
        return 0;
    }

    public boolean isLocationSuitableForNewLeaves(LevelAccessor level, LeavesProperties leavesProperties, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof DynamicLeavesBlock) {
            return false;
        }
        if (!blockState.getFluidState().isEmpty() && !this.properties.waterResistant) {
            return false;
        }
        BlockState belowBlockState = level.getBlockState(pos.below());
        if (!leavesProperties.canGrowOnGround() && (belowBlockState.canOcclude() && !TreeHelper.isBranch(belowBlockState) && !(belowBlockState.getBlock() instanceof LeavesBlock) || belowBlockState.getBlock() instanceof LiquidBlock)) {
            return false;
        }
        BlockState stateDown = level.getBlockState(pos.below());
        if (block instanceof DoublePlantBlock && blockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER && stateDown.getBlock() instanceof DoublePlantBlock && stateDown.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER) {
            if (block == Blocks.TALL_GRASS) {
                level.setBlock(pos.below(), Blocks.SHORT_GRASS.defaultBlockState(), 3);
            } else if (block == Blocks.LARGE_FERN) {
                level.setBlock(pos.below(), Blocks.FERN.defaultBlockState(), 3);
            }
            level.removeBlock(pos, false);
        }
        return (level.isEmptyBlock(pos) || level.getBlockState(pos).canBeReplaced()) && this.hasAdequateLight(blockState, level, leavesProperties, pos);
    }

    public boolean hasAdequateLight(BlockState state, LevelAccessor level, LeavesProperties leavesProperties, BlockPos pos) {
        if (level.canSeeSkyFromBelowWater(pos)) {
            return true;
        }
        int smother = leavesProperties.getSmotherLeavesMax();
        if (smother != 0 && DynamicLeavesBlock.isBottom(level, pos)) {
            int smotherLeaves = 0;
            for (int i = 0; i < smother; ++i) {
                smotherLeaves += TreeHelper.isTreePart(level, pos.above(i + 1)) ? 1 : 0;
            }
            if (smotherLeaves >= smother) {
                return false;
            }
        }
        return level.getBrightness(LightLayer.SKY, pos) >= (TreeHelper.isLeaves(state) ? leavesProperties.getLightRequirement() - 2 : leavesProperties.getLightRequirement());
    }

    public boolean removeIfInvalid(BlockState state, LevelAccessor level, BlockPos pos, RandomSource rand) {
        if (this.getLeavesProperties().updateTick(level, pos, state, rand)) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && !this.properties.waterResistant) {
                level.setBlock(pos, this.getFluidState(state).createLegacyBlock(), 3);
                return true;
            }
            if (!this.hasAdequateLight(state, level, this.getLeavesProperties(), pos)) {
                level.removeBlock(pos, false);
                return true;
            }
        }
        return false;
    }

    public static boolean isBottom(LevelAccessor level, BlockPos pos) {
        BlockState belowBlockState = level.getBlockState(pos.below());
        TreePart belowTreepart = TreeHelper.getTreePart(belowBlockState);
        if (belowTreepart != TreeHelper.NULL_TREE_PART) {
            return belowTreepart.getRadius(belowBlockState) > 1;
        }
        return true;
    }

    public int getHydrationLevelFromNeighbors(LevelAccessor level, BlockPos pos, LeavesProperties leavesProperties) {
        Cell[] cells = new Cell[6];
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.relative(dir);
            BlockState state = level.getBlockState(deltaPos);
            TreePart part = TreeHelper.getTreePart(state);
            cells[dir.ordinal()] = part.getHydrationCell((BlockGetter)level, deltaPos, state, dir, leavesProperties);
        }
        return leavesProperties.getCellKit().getCellSolver().solve(cells);
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties otherProperties) {
        LeavesProperties thisProperties = this.getLeavesProperties();
        return thisProperties.isCompatibleLeaves(otherProperties) ? thisProperties.getCellKit().getCellForLeaves((Integer)state.getValue((Property)LeavesBlock.DISTANCE)) : CellNull.NULL_CELL;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            this.branchOut(level, pos, signal);
        }
        return signal;
    }

    public boolean needLeaves(Level level, BlockPos pos, LeavesProperties leavesProperties, Species species) {
        if (level.isEmptyBlock(pos)) {
            return 0 != this.growLeavesIfLocationIsSuitable((LevelAccessor)level, leavesProperties, pos, leavesProperties.getCellKit().getDefaultHydration());
        }
        BlockState state = level.getBlockState(pos);
        TreePart treePart = TreeHelper.getTreePart(state);
        return treePart instanceof DynamicLeavesBlock && species.isValidLeafBlock((DynamicLeavesBlock)treePart);
    }

    public GrowSignal branchOut(Level level, BlockPos pos, GrowSignal signal) {
        Species species = signal.getSpecies();
        LeavesProperties leavesProperties = species.getLeavesProperties();
        if (!this.needLeaves(level, pos, leavesProperties, species)) {
            signal.success = false;
            return signal;
        }
        if (BranchBlock.isNextToBranch(level, pos, signal.dir.getOpposite())) {
            signal.success = false;
            return signal;
        }
        boolean hasLeaves = false;
        for (Direction dir : Direction.values()) {
            if (!this.needLeaves(level, pos.relative(dir), leavesProperties, species)) continue;
            hasLeaves = true;
            break;
        }
        this.updateAllLeaves((LevelAccessor)level, pos, level.getBlockState(pos), signal.rand, false);
        if (hasLeaves) {
            Family family = species.getFamily();
            family.getBranchForPlacement((LevelAccessor)level, species, pos).ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
            signal.radius = family.getSecondaryThickness();
        }
        signal.success = hasLeaves;
        return signal;
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return from.getFamily().isCompatibleDynamicLeaves(from.getFamily().getCommonSpecies(), state, level, pos) ? 2 : 0;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.isEntityPassable(pContext)) {
            return Shapes.empty();
        }
        return super.getShape(pState, pLevel, pPos, pContext);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.isLeavesPassable() || this.isEntityPassable(context)) {
            return Shapes.empty();
        }
        if (this.isMovementVanilla()) {
            return Shapes.block();
        }
        return Shapes.create((AABB)new AABB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875));
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SUPPORT_SHAPE;
    }

    protected boolean isMovementVanilla() {
        return Services.CONFIG.isServerConfigLoaded() && Services.CONFIG.getBoolConfig("vanillaLeavesCollision") != false;
    }

    protected boolean isLeavesPassable() {
        return Services.CONFIG.isServerConfigLoaded() && Services.CONFIG.getBoolConfig("isLeavesPassable") != false || Services.PLATFORM.isModLoaded("passablefoliage");
    }

    public boolean isEntityPassable(CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)context;
            return this.isEntityPassable(entityCollisionContext.getEntity());
        }
        return false;
    }

    public boolean isEntityPassable(@Nullable Entity entity) {
        if (entity instanceof Projectile) {
            return true;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemEntity.getItem().getItem() instanceof Seed;
        }
        return entity != null && entity.getType().is(DTEntityTypeTags.CAN_PASS_THROUGH_LEAVES);
    }

    protected void superFallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, blockState, pos, entity, fallDistance);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!Services.CONFIG.getBoolConfig("enableCanopyCrash").booleanValue() || !(entity instanceof LivingEntity)) {
            return;
        }
        entity.fallDistance -= 1.0f;
        AABB aabb = entity.getBoundingBox();
        int minX = Mth.floor((double)(aabb.minX + 0.001));
        int minZ = Mth.floor((double)(aabb.minZ + 0.001));
        int maxX = Mth.floor((double)(aabb.maxX - 0.001));
        int maxZ = Mth.floor((double)(aabb.maxZ - 0.001));
        boolean crushing = true;
        boolean hasLeaves = true;
        SoundType stepSound = this.getSoundType(level.getBlockState(pos));
        float volume = Mth.clamp((float)(stepSound.getVolume() / 16.0f * fallDistance), (float)0.0f, (float)3.0f);
        level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), stepSound.getBreakSound(), SoundSource.BLOCKS, volume, stepSound.getPitch(), false);
        int iy = 0;
        while (entity.fallDistance > 3.0f && crushing && pos.getY() - iy >= level.getMinBuildHeight()) {
            if (hasLeaves) {
                entity.fallDistance *= 0.66f;
                hasLeaves = false;
            }
            for (int ix = minX; ix <= maxX; ++ix) {
                for (int iz = minZ; iz <= maxZ; ++iz) {
                    BlockPos iPos = new BlockPos(ix, pos.getY() - iy, iz);
                    BlockState crashState = level.getBlockState(iPos);
                    if (TreeHelper.isLeaves(crashState)) {
                        hasLeaves = true;
                        ParticleHelper.crushLeavesBlock(level, iPos, crashState, entity);
                        level.removeBlock(iPos, false);
                        continue;
                    }
                    if (level.isEmptyBlock(iPos)) continue;
                    crushing = false;
                }
            }
            ++iy;
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Player player;
        if (this.isMovementVanilla() || this.isEntityPassable(entity) || entity instanceof Player && (player = (Player)entity).isCreative() && player.getAbilities().flying) {
            super.entityInside(state, level, pos, entity);
        } else {
            if (entity.getDeltaMovement().y < 0.0 && (this.isLeavesPassable() || entity.fallDistance < 2.0f)) {
                entity.fallDistance = 0.0f;
                entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y * 0.5, entity.getDeltaMovement().z);
            } else if (!this.isLeavesPassable() && entity.getDeltaMovement().y > 0.0 && entity.getDeltaMovement().y < 0.25) {
                entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y + 0.025, entity.getDeltaMovement().z);
            }
            entity.setSprinting(false);
            entity.setDeltaMovement(entity.getDeltaMovement().x * 0.25, entity.getDeltaMovement().y, entity.getDeltaMovement().z * 0.25);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        LootTable lootTable;
        Vec3 originPos = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
        Species species = Species.NULL_SPECIES;
        BlockPos pos = BlockPos.ZERO;
        ServerLevel level = builder.getLevel();
        if (originPos == null) {
            lootTable = level.getServer().reloadableRegistries().getLootTable(this.getLootTable());
        } else {
            pos = BlockPos.containing((double)originPos.x, (double)originPos.y, (double)originPos.z);
            LeavesProperties leavesProperties = this.getLeavesProperties();
            species = this.getExactSpecies((Level)level, pos, leavesProperties);
            lootTable = leavesProperties.getBlockLootTable(level.getServer().reloadableRegistries(), species);
        }
        if (lootTable == LootTable.EMPTY) {
            return Collections.emptyList();
        }
        LootParams context = builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(DTLootContextParams.SPECIES, (Object)species).withParameter(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), pos))).create(LootContextParamSets.BLOCK);
        return lootTable.getRandomItems(context);
    }

    Species getExactSpecies(@Nullable Level level, BlockPos pos, LeavesProperties leavesProperties) {
        if (level == null) {
            return Species.NULL_SPECIES;
        }
        ArrayList<BlockPos> branchList = new ArrayList<BlockPos>();
        for (BlockPos blockPos : leavesProperties.getCellKit().getLeafCluster().getAllNonZero()) {
            BranchBlock branch;
            BlockPos blockPos2 = pos.offset((Vec3i)BlockPos.ZERO.subtract((Vec3i)blockPos));
            BlockState state = level.getBlockState(blockPos2);
            if (!TreeHelper.isBranch(state) || (branch = TreeHelper.getBranch(state)).getFamily() != leavesProperties.getFamily() || branch.getRadius(state) != branch.getFamily().getPrimaryThickness()) continue;
            branchList.add(blockPos2);
        }
        if (branchList.isEmpty()) {
            return Species.NULL_SPECIES;
        }
        BlockPos closest = (BlockPos)branchList.getFirst();
        double d = 999.0;
        for (BlockPos dPos : branchList) {
            double d2 = pos.distSqr((Vec3i)dPos);
            if (!(d2 < d)) continue;
            d = d2;
            closest = dPos;
        }
        return TreeHelper.getExactSpecies(level, closest);
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getLeavesProperties().getRadiusForConnection(state, level, pos, from, side, fromRadius);
    }

    @Override
    public int getRadius(BlockState state) {
        return 0;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    @Override
    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return radius == branch.getFamily().getPrimaryThickness() && branch.getFamily() == this.getFamily(state, level, pos) ? BranchBlock.setSupport(0, 1) : 0;
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.LEAVES;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.properties.hasTickParticles && this.properties.getPrimitiveLeavesBlock().isPresent()) {
            this.properties.getPrimitiveLeavesBlock().ifPresent(b -> b.animateTick(state, level, pos, random));
        } else {
            super.animateTick(state, level, pos, random);
        }
    }
}

