/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.api.network.RootConnections;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public class SurfaceRootBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_RADIUS = 8;
    protected static final IntegerProperty RADIUS = IntegerProperty.create((String)"radius", (int)1, (int)8);
    public static final BooleanProperty GROUNDED = BooleanProperty.create((String)"grounded");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Family family;

    public SurfaceRootBlock(Family family) {
        this(MapColor.WOOD, family);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public SurfaceRootBlock(MapColor mapColor, Family family) {
        super(BlockBehaviour.Properties.of().mapColor(mapColor).strength(2.5f, 1.0f).sound(SoundType.WOOD));
        this.family = family;
    }

    public Family getFamily() {
        return this.family;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.family.getBranchItem().map(ItemStack::new).orElse(ItemStack.EMPTY);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RADIUS, GROUNDED, WATERLOGGED});
    }

    public int getRadius(BlockState blockState) {
        return blockState.getBlock() == this ? (Integer)blockState.getValue((Property)RADIUS) : 0;
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, int flags) {
        boolean replacingWater = level.getBlockState(pos).getFluidState() == Fluids.WATER.getSource(false);
        level.setBlock(pos, (BlockState)this.getStateForRadius(radius).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(replacingWater)), flags);
        return radius;
    }

    public BlockState getStateForRadius(int radius) {
        return (BlockState)this.defaultBlockState().setValue((Property)RADIUS, (Comparable)Integer.valueOf(Mth.clamp((int)radius, (int)0, (int)this.getMaxRadius())));
    }

    public int getMaxRadius() {
        return 8;
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.getFluidTicks().schedule(new ScheduledTick((Object)Fluids.WATER, currentPos, (long)Fluids.WATER.getTickDelay((LevelReader)level), 1L));
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public RootConnections getConnectionData(BlockAndTintGetter level, BlockPos pos) {
        RootConnections connections = new RootConnections();
        for (Direction dir : CoordUtils.HORIZONTALS) {
            RootConnection connection = this.getSideConnectionRadius((BlockGetter)level, pos, dir);
            if (connection == null) continue;
            connections.setRadius(dir, connection.radius);
            connections.setConnectionLevel(dir, connection.level);
        }
        return connections;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean connectionMade = false;
        int thisRadius = this.getRadius(state);
        VoxelShape shape = Shapes.empty();
        for (Direction dir : CoordUtils.HORIZONTALS) {
            RootConnection conn = this.getSideConnectionRadius(level, pos, dir);
            if (conn == null) continue;
            connectionMade = true;
            int r = Mth.clamp((int)conn.radius, (int)1, (int)thisRadius);
            double radius = (double)r / 16.0;
            double radialHeight = (double)this.getRadialHeight(r) / 16.0;
            double gap = 0.5 - radius;
            AABB aabb = new AABB(-radius, 0.0, -radius, radius, radialHeight, radius);
            aabb = aabb.expandTowards((double)dir.getStepX() * gap, 0.0, (double)dir.getStepZ() * gap).move(0.5, 0.0, 0.5);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        if (!connectionMade) {
            double radius = (double)thisRadius / 16.0;
            double radialHeight = (double)this.getRadialHeight(thisRadius) / 16.0;
            AABB aabb = new AABB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, radialHeight, 0.5 + radius);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    private boolean isAirOrWater(BlockState state) {
        return state.getBlock() == Blocks.AIR || state.getBlock() == Blocks.WATER;
    }

    @Nullable
    protected RootConnection getSideConnectionRadius(BlockGetter level, BlockPos pos, Direction side) {
        RootConnections.ConnectionLevel connectionLevel;
        if (!side.getAxis().isHorizontal()) {
            return null;
        }
        BlockPos dPos = pos.relative(side);
        BlockState state = ChunkTreeHelper.getStateSafe(level, dPos);
        BlockState upState = ChunkTreeHelper.getStateSafe(level, pos.above());
        RootConnections.ConnectionLevel connectionLevel2 = upState != null && this.isAirOrWater(upState) && state != null && state.isRedstoneConductor(level, dPos) ? RootConnections.ConnectionLevel.HIGH : (connectionLevel = state != null && this.isAirOrWater(state) ? RootConnections.ConnectionLevel.LOW : RootConnections.ConnectionLevel.MID);
        if (connectionLevel != RootConnections.ConnectionLevel.MID) {
            dPos = dPos.above(connectionLevel.getYOffset());
            state = ChunkTreeHelper.getStateSafe(level, dPos);
        }
        if (state != null && state.getBlock() instanceof SurfaceRootBlock) {
            return new RootConnection(connectionLevel, ((SurfaceRootBlock)state.getBlock()).getRadius(state));
        }
        if (connectionLevel == RootConnections.ConnectionLevel.MID && TreeHelper.isBranch(state)) {
            return new RootConnection(RootConnections.ConnectionLevel.MID, Math.min(TreeHelper.getTreePart(state).getRadius(state), 8));
        }
        return null;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(level, pos, state)) {
            level.removeBlock(pos, false);
        }
    }

    protected boolean canBlockStay(Level level, BlockPos pos, BlockState state) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        int radius = this.getRadius(state);
        if (belowState.isRedstoneConductor((BlockGetter)level, below)) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                RootConnection conn = this.getSideConnectionRadius((BlockGetter)level, pos, dir);
                if (conn == null || conn.radius <= radius) continue;
                return true;
            }
        } else {
            boolean connections = false;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                RootConnection conn = this.getSideConnectionRadius((BlockGetter)level, pos, dir);
                if (conn == null) continue;
                if (conn.level == RootConnections.ConnectionLevel.MID) {
                    return false;
                }
                if (conn.radius <= radius) continue;
                connections = true;
            }
            return connections;
        }
        return false;
    }

    public static class RootConnection {
        public RootConnections.ConnectionLevel level;
        public int radius;

        public RootConnection(RootConnections.ConnectionLevel level, int radius) {
            this.level = level;
            this.radius = radius;
        }

        public String toString() {
            return super.toString() + " Level: " + this.level.toString() + " Radius: " + this.radius;
        }
    }
}

