/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.pod.OffsetablePodBlock;
import com.dtteam.dynamictrees.block.soil.AerialRootsSoilProperties;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.loot.LootTableSupplier;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.dtteam.dynamictrees.systems.nodemapper.RootsDestroyerNode;
import com.dtteam.dynamictrees.systems.nodemapper.SpeciesNode;
import com.dtteam.dynamictrees.systems.nodemapper.StateNode;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.tree.species.UndergroundRootsSpecies;
import com.dtteam.dynamictrees.utility.EntityUtils;
import com.dtteam.dynamictrees.utility.ItemUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRootsBlock
extends BranchBlock
implements SimpleWaterloggedBlock {
    public static final String NAME_SUFFIX = "_roots";
    public static final IntegerProperty RADIUS = IntegerProperty.create((String)"radius", (int)1, (int)8);
    public static final EnumProperty<Layer> LAYER = EnumProperty.create((String)"layer", Layer.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Logger log = LoggerFactory.getLogger(BasicRootsBlock.class);
    private int flammability = 5;
    private int fireSpreadSpeed = 5;
    private final LootTableSupplier rootLootTableSupplier;

    public BasicRootsBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(LAYER, (Comparable)((Object)Layer.EXPOSED)));
        this.rootLootTableSupplier = new LootTableSupplier("trees/roots/", name);
    }

    public boolean isFullBlock(BlockState state) {
        return state.getValue(LAYER) == Layer.COVERED;
    }

    @Override
    public UndergroundRootsFamily getFamily() {
        return (UndergroundRootsFamily)super.getFamily();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        int radius = this.getRadius(level.getBlockState(pos));
        return this.fireSpreadSpeed * radius / 8;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.flammability;
    }

    public BasicRootsBlock setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public BasicRootsBlock setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RADIUS, LAYER, WATERLOGGED});
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return 10;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(state);
    }

    @Override
    public int getRadius(BlockState state) {
        return this.isSameTree(state) && state.hasProperty((Property)RADIUS) ? (Integer)state.getValue((Property)RADIUS) : 0;
    }

    protected int getMaxSignalDepth() {
        return this.getFamily().getMaxSignalDepth();
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        if (branch instanceof BasicRootsBlock) {
            return this.isSameTree(branch) ? BasicBranchBlock.setSupport(1, 0) : 0;
        }
        return 0;
    }

    @Override
    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        Layer layer;
        boolean isFullBlock;
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        BlockState currentState = level.getBlockState(pos);
        boolean replacingWater = currentState.getFluidState() == Fluids.WATER.getSource(false);
        boolean replacingGround = this.getFamily().isAcceptableSoilForRootSystem(currentState);
        boolean setWaterlogged = replacingWater && !replacingGround;
        boolean bl = isFullBlock = radius >= 8;
        if (currentState.is((Block)this)) {
            layer = (Layer)((Object)currentState.getValue(LAYER));
            if (layer == Layer.COVERED && isFullBlock) {
                layer = Layer.FILLED;
            }
        } else {
            layer = replacingGround ? Layer.COVERED : Layer.EXPOSED;
        }
        level.setBlock(pos, (BlockState)((BlockState)this.getStateForRadius(radius).setValue(LAYER, (Comparable)((Object)layer))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    @Override
    public BlockState getStateForRadius(int radius) {
        return (BlockState)this.defaultBlockState().setValue((Property)RADIUS, (Comparable)Integer.valueOf(radius));
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        if (this.isFullBlock(state) && this.getFamily().getPrimitiveCoveredRoots().isPresent()) {
            return new ItemStack((ItemLike)this.getFamily().getPrimitiveCoveredRoots().get());
        }
        return new ItemStack((ItemLike)this.asItem());
    }

    protected SoundType getSoundType(BlockState state) {
        Optional<Block> primitive = ((Layer)((Object)state.getValue(LAYER))).getPrimitive(this.getFamily());
        return primitive.map(block -> block.defaultBlockState().getSoundType()).orElseGet(() -> super.getSoundType(state));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return !this.isFullBlock(state) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (this.canPlaceLiquid(null, (BlockGetter)pLevel, pPos, pState, pFluidState.getType())) {
            if (!pLevel.isClientSide()) {
                pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue(LAYER, (Comparable)((Object)Layer.EXPOSED)), 3);
                pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getLootTableName() {
        return this.rootLootTableSupplier.getName();
    }

    @Override
    public LootTable getLootTable(ReloadableServerRegistries.Holder lootTables, Species species) {
        return this.rootLootTableSupplier.get(lootTables, species);
    }

    @Override
    public Optional<Block> getPrimitiveLog() {
        return this.getFamily().getPrimitiveRoots();
    }

    protected boolean canPlace(Player player, Level level, BlockPos clickedPos, BlockState pState) {
        CollisionContext collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return pState.canSurvive((LevelReader)level, clickedPos) && level.isUnobstructed(pState, clickedPos, collisioncontext);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!this.isFullBlock(state)) {
            Layer layer = Layer.COVERED;
            if ((Integer)state.getValue((Property)RADIUS) >= 8) {
                layer = state.getValue(LAYER) == Layer.EXPOSED ? Layer.FILLED : null;
            }
            if (layer != null) {
                BlockState newState;
                ItemStack handStack = player.getItemInHand(hand);
                Block coverBlock = this.getFamily().getPrimitiveCoveredRoots().orElse(null);
                if (coverBlock != null && handStack.getItem() == coverBlock.asItem() && this.canPlace(player, level, pos, newState = (BlockState)((BlockState)state.setValue(LAYER, (Comparable)((Object)layer))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)))) {
                    level.setBlock(pos, newState, 3);
                    if (!player.isCreative()) {
                        handStack.shrink(1);
                    }
                    level.playSound(null, pos, coverBlock.defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.isFullBlock(state)) {
            level.setBlock(pos, (BlockState)state.setValue(LAYER, (Comparable)((Object)Layer.FILLED)), level.isClientSide ? 11 : 3);
            this.spawnDestroyParticles(level, player, pos, state);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            Block primitive = ((Layer)((Object)state.getValue(LAYER))).getPrimitive(this.getFamily()).orElse(null);
            if (!player.isCreative() && primitive != null) {
                BasicRootsBlock.dropResources((BlockState)primitive.defaultBlockState(), (Level)level, (BlockPos)pos);
            }
            return false;
        }
        if (!level.isClientSide()) {
            Block block = level.getBlockState(pos.above()).getBlock();
            if (block instanceof AerialRootsSoilProperties.RootSoilBlock) {
                AerialRootsSoilProperties.RootSoilBlock aerialSoil = (AerialRootsSoilProperties.RootSoilBlock)block;
                aerialSoil.dropWholeTree(level, pos.above(), player, FallingTreeEntity.DestroyType.HARVEST);
                return false;
            }
            SpeciesNode speciesNode = new SpeciesNode();
            MapSignal signal = this.analyse(state, (LevelAccessor)level, pos, null, new MapSignal(speciesNode));
            if (signal.foundRoot) {
                level.scheduleTick(signal.root, level.getBlockState(signal.root).getBlock(), 2);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void DropTreeIfUnsupported(Level level, BlockPos rootPos, @Nullable Player player, FallingTreeEntity.DestroyType destroyType) {
        AerialRootsSoilProperties.RootSoilBlock rootyBlock;
        Block block = level.getBlockState(rootPos).getBlock();
        if (block instanceof AerialRootsSoilProperties.RootSoilBlock && (rootyBlock = (AerialRootsSoilProperties.RootSoilBlock)block).isStructurallyUnstable((LevelAccessor)level, rootPos)) {
            rootyBlock.dropWholeTree(level, rootPos, player, destroyType);
        }
    }

    @Override
    public void futureBreak(BlockState state, Level level, BlockPos cutPos, LivingEntity entity) {
        Direction toolDir = EntityUtils.getHitDirection(entity);
        level.levelEvent(null, 2001, cutPos, BasicRootsBlock.getId((BlockState)state));
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, cutPos, toolDir, false, entity);
        ItemStack heldItem = entity.getMainHandItem();
        int fortune = ItemUtils.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.FORTUNE, heldItem, level.registryAccess());
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
        woodVolume.multiplyVolume(fortuneFactor);
        List<ItemStack> woodItems = destroyData.species.getBranchesDrops(level, woodVolume, heldItem);
        FallingTreeEntity.dropTree(level, destroyData, woodItems, FallingTreeEntity.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume, true);
    }

    @Override
    public BranchDestructionData destroyBranchFromNode(Level level, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
        BlockState blockState = level.getBlockState(cutPos);
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(blockState, (LevelAccessor)level, cutPos, null, new MapSignal(speciesNode));
        Species species = speciesNode.getSpecies();
        StateNode stateMapper = new StateNode(cutPos);
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(stateMapper));
        NetVolumeNode volumeSum = new NetVolumeNode();
        RootsDestroyerNode destroyer = new RootsDestroyerNode(this.getFamily());
        destroyMode = DynamicTrees.DestroyMode.HARVEST;
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(volumeSum, destroyer));
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.above();
        }
        Direction cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = Direction.UP;
        }
        BlockPos lowestBlock = stateMapper.getBranchConnectionMap().keySet().stream().min(Comparator.comparingInt(Vec3i::getY)).orElse(BlockPos.ZERO);
        BlockPos.MutableBlockPos basePos = new BlockPos((Vec3i)cutPos).mutable();
        for (int i = 0; i > lowestBlock.getY() && level.getBlockState(basePos.move(0, -1, 0).below()).canBeReplaced(); --i) {
        }
        return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), new HashMap<BlockPos, BlockState>(), new ArrayList<BranchBlock.ItemStackPos>(), destroyer.getEnds(), volumeSum.getVolume(), cutPos, (BlockPos)basePos, cutDir, toolDir, trunkHeight);
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.isFullBlock(state)) {
            return this.getFamily().getPrimitiveCoveredRoots().orElse(Blocks.AIR).defaultDestroyTime();
        }
        int radius = this.getRadius(level.getBlockState(pos));
        double hardness = (double)this.getFamily().getPrimitiveLog().orElse(Blocks.AIR).defaultBlockState().getDestroySpeed(level, pos) * Services.CONFIG.getDoubleConfig("treeHardnessMultiplier") * (double)(radius * radius) / 64.0 * 8.0;
        return (float)Math.min(hardness, Services.CONFIG.getDoubleConfig("maxTreeHardness"));
    }

    @Override
    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean waterlogged = state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        Layer layer = state.hasProperty(LAYER) ? (Layer)((Object)state.getValue(LAYER)) : Layer.EXPOSED;
        Block primitive = layer == Layer.COVERED && layer.getPrimitive(this.getFamily()).isPresent() ? layer.getPrimitive(this.getFamily()).get() : Blocks.AIR;
        return waterlogged ? Blocks.WATER.defaultBlockState() : primitive.defaultBlockState();
    }

    @Deprecated
    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        Optional<Block> covered = this.getFamily().getPrimitiveCoveredRoots();
        if (pState.hasProperty(LAYER) && pState.getValue(LAYER) == Layer.COVERED && covered.isPresent()) {
            return covered.get().defaultBlockState().getDestroyProgress(pPlayer, pLevel, pPos);
        }
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    @Override
    public boolean checkForRot(LevelAccessor level, BlockPos pos, Species species, int fertility, int radius, RandomSource rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.nextFloat() > chance)) {
            return false;
        }
        if (this.isFullBlock(level.getBlockState(pos))) {
            return false;
        }
        int neigh = 0;
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.relative(dir);
            BlockState deltaBlockState = level.getBlockState(deltaPos);
            if (BasicRootsBlock.getBranchSupport(neigh += TreeHelper.getTreePart(deltaBlockState).branchSupport(deltaBlockState, (BlockGetter)level, this, deltaPos, dir, radius)) < 2) continue;
            return false;
        }
        boolean didRot = species.rot(level, pos, neigh & 0xF, radius, fertility, rand, true, false);
        if (rapid && didRot) {
            for (Direction dir : Direction.values()) {
                BlockPos neighPos = pos.relative(dir);
                BlockState neighState = level.getBlockState(neighPos);
                if (neighState.getBlock() != this) continue;
                this.checkForRot(level, neighPos, species, fertility, this.getRadius(neighState), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.isFullBlock(pState)) {
            VoxelShape fullShape = Shapes.block();
            if (this.getFamily().getPrimitiveCoveredRoots().isPresent()) {
                fullShape = this.getFamily().getPrimitiveCoveredRoots().get().defaultBlockState().getCollisionShape(pLevel, pPos, pContext);
            }
            return fullShape;
        }
        return super.getCollisionShape(pState, pLevel, pPos, pContext);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        if (this.isFullBlock(state)) {
            return Shapes.block();
        }
        int thisRadiusInt = this.getRadius(state);
        double radius = (double)thisRadiusInt / 16.0;
        VoxelShape core = Shapes.box((double)(0.5 - radius), (double)(0.5 - radius), (double)(0.5 - radius), (double)(0.5 + radius), (double)(0.5 + radius), (double)(0.5 + radius));
        for (Direction dir : Direction.values()) {
            int sideRadiusInt = Math.min(this.getSideConnectionRadius(level, pos, thisRadiusInt, dir), thisRadiusInt);
            double sideRadius = (float)sideRadiusInt / 16.0f;
            if (!(sideRadius > 0.0)) continue;
            double gap = 0.5 - sideRadius;
            AABB aabb = new AABB(0.5 - sideRadius, 0.5 - sideRadius, 0.5 - sideRadius, 0.5 + sideRadius, 0.5 + sideRadius, 0.5 + sideRadius);
            aabb = aabb.expandTowards((double)dir.getStepX() * gap, (double)dir.getStepY() * gap, (double)dir.getStepZ() * gap);
            core = Shapes.or((VoxelShape)core, (VoxelShape)Shapes.create((AABB)aabb));
        }
        return core;
    }

    protected int getSideConnectionRadius(BlockGetter level, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.relative(side);
        BlockState blockState = ChunkTreeHelper.getStateSafe(level, deltaPos);
        return blockState == null ? 0 : TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, level, deltaPos, this, side, radius);
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (BasicRootsBlock.isTransparent(pState)) {
            return Shapes.empty();
        }
        return super.getOcclusionShape(pState, pLevel, pPos);
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        if (BasicRootsBlock.isTransparent(pState)) {
            return Shapes.empty();
        }
        return super.getVisualShape(pState, pReader, pPos, pContext);
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.is((Block)this) && ((Layer)((Object)pAdjacentBlockState.getValue(LAYER))).ordinal() >= ((Layer)((Object)pState.getValue(LAYER))).ordinal() || super.skipRendering(pState, pAdjacentBlockState, pSide);
    }

    public static boolean isTransparent(BlockState state) {
        return state.getBlock() instanceof BasicRootsBlock && state.getValue(LAYER) == Layer.EXPOSED;
    }

    private boolean canGrowInto(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        boolean isFree = this.getFamily().isAcceptableSoilForRootSystem(state) || state.canBeReplaced();
        return isFree || state.getBlock() instanceof BasicRootsBlock;
    }

    private boolean isNextToSoil(Level level, BlockPos pos, Direction originDir) {
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || !TreeHelper.isRooty(level.getBlockState(pos.relative(dir)))) continue;
            return true;
        }
        return false;
    }

    public GrowSignal growIntoAir(Level level, BlockPos pos, GrowSignal signal, int fromRadius, boolean fromGround) {
        if (BasicRootsBlock.isNextToBranch(level, pos, signal.dir.getOpposite()) || this.isNextToSoil(level, pos, signal.dir.getOpposite())) {
            signal.success = false;
            return signal;
        }
        int supportExtraThickness = 0;
        int radius = this.getFamily().getPrimaryRootThickness() + supportExtraThickness;
        this.setRadius((LevelAccessor)level, pos, radius, null);
        signal.radius = this.getFamily().getSecondaryRootThickness() + supportExtraThickness;
        signal.success = true;
        return signal;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        Block deltaPos;
        if (!signal.step()) {
            return signal;
        }
        BlockState currBlockState = level.getBlockState(pos);
        Species species = signal.getSpecies();
        if (!(species instanceof UndergroundRootsSpecies)) {
            return signal;
        }
        UndergroundRootsSpecies speciesMangrove = (UndergroundRootsSpecies)species;
        Direction originDir = signal.dir.getOpposite();
        Direction targetDir = speciesMangrove.getRootsGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(level, pos, species, this, signal));
        signal.doTurn(targetDir);
        BlockPos deltaPos2 = pos.relative(targetDir);
        BlockState deltaState = level.getBlockState(deltaPos2);
        Direction[] treepart = TreeHelper.getTreePart(deltaState);
        if (treepart != TreeHelper.NULL_TREE_PART) {
            signal = treepart.growSignal(level, deltaPos2, signal);
        } else if (this.canGrowInto(level, deltaPos2)) {
            signal = this.growIntoAir(level, deltaPos2, signal, this.getRadius(currBlockState), this.isFullBlock(currBlockState));
        }
        float areaAccum = signal.radius * signal.radius;
        boolean theresPods = false;
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || dir.equals((Object)targetDir)) continue;
            deltaPos = pos.relative(dir);
            BlockState blockState = level.getBlockState((BlockPos)deltaPos);
            TreePart treepart2 = TreeHelper.getTreePart(blockState);
            if (this.isSameTree(treepart2)) {
                int branchRadius = treepart2.getRadius(blockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (!(blockState.getBlock() instanceof OffsetablePodBlock)) continue;
            theresPods = true;
        }
        if (!signal.choked) {
            int rootThickness = 8;
            BlockState rootState = level.getBlockState(signal.rootPos);
            deltaPos = rootState.getBlock();
            if (deltaPos instanceof AerialRootsSoilProperties.RootSoilBlock) {
                AerialRootsSoilProperties.RootSoilBlock rootyRoot = (AerialRootsSoilProperties.RootSoilBlock)deltaPos;
                rootThickness = Math.min(rootyRoot.getRadius(rootState), 8);
            } else {
                SoilBlock rooty;
                Direction dir;
                BlockPos treePos;
                deltaPos = rootState.getBlock();
                if (deltaPos instanceof SoilBlock && TreeHelper.isBranch(level.getBlockState(treePos = signal.rootPos.relative(dir = (rooty = (SoilBlock)deltaPos).getTrunkDirection((BlockGetter)level, signal.rootPos))))) {
                    rootThickness = TreeHelper.getRadius((BlockGetter)level, treePos);
                }
            }
            int maxRadius = Math.min(8, Math.min(species.getMaxBranchRadius(), rootThickness));
            signal.radius = Mth.clamp((float)((float)Math.sqrt(areaAccum) + speciesMangrove.getRootTapering()), (float)this.getRadius(currBlockState), (float)maxRadius);
            int targetRadius = (int)Math.floor(signal.radius);
            int flags = theresPods ? 3 : 2;
            int setRad = this.setRadius((LevelAccessor)level, pos, targetRadius, originDir, flags);
            if (setRad < targetRadius) {
                signal.choked = true;
            }
        }
        return signal;
    }

    @Override
    public MapSignal analyse(BlockState blockState, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        if (signal.overflow || signal.trackVisited && signal.doTrackingVisited(pos)) {
            return signal;
        }
        if (signal.depth++ < this.getMaxSignalDepth()) {
            signal.run(blockState, level, pos, fromDir);
            for (Direction dir : Direction.values()) {
                BlockPos deltaPos;
                BlockState deltaState;
                TreePart treePart;
                if (dir == fromDir || !(treePart = TreeHelper.getTreePart(deltaState = level.getBlockState(deltaPos = pos.relative(dir)))).shouldAnalyse(deltaState, (BlockGetter)level, deltaPos)) continue;
                signal = treePart.analyse(deltaState, level, deltaPos, dir.getOpposite(), signal);
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, level, pos, fromDir);
        } else {
            Block block;
            BlockState state = level.getBlockState(pos);
            if (signal.destroyLoopedNodes && (block = state.getBlock()) instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)block;
                branch.breakDeliberate(level, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public static enum Layer implements StringRepresentable
    {
        EXPOSED(UndergroundRootsFamily::getPrimitiveRoots),
        FILLED(UndergroundRootsFamily::getPrimitiveFilledRoots),
        COVERED(UndergroundRootsFamily::getPrimitiveCoveredRoots);

        final Function<UndergroundRootsFamily, Optional<Block>> primitiveFunc;

        private Layer(Function<UndergroundRootsFamily, Optional<Block>> primitiveFunc) {
            this.primitiveFunc = primitiveFunc;
        }

        @NotNull
        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public Optional<Block> getPrimitive(UndergroundRootsFamily family) {
            return this.primitiveFunc.apply(family);
        }
    }
}

