/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import oshi.util.tuples.Pair;

public final class DynamicBlockProperties {
    private static final Map<Integer, IntegerProperty> AGE_PROPERTIES = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(1, BlockStateProperties.AGE_1);
        map.put(2, BlockStateProperties.AGE_2);
        map.put(3, BlockStateProperties.AGE_3);
        map.put(5, BlockStateProperties.AGE_5);
        map.put(7, BlockStateProperties.AGE_7);
        map.put(15, BlockStateProperties.AGE_15);
        map.put(25, BlockStateProperties.AGE_25);
    });
    public static final int[] defaultAges = new int[]{1, 2, 3, 5, 7, 15, 25};
    private static final Map<Pair<Integer, Integer>, IntegerProperty> OFFSET_PROPERTIES = (Map)Util.make((Object)Maps.newHashMap(), map -> map.put(new Pair((Object)4, (Object)8), IntegerProperty.create((String)"radius_offset", (int)4, (int)8)));

    private DynamicBlockProperties() {
    }

    public static IntegerProperty getOrCreateAge(int maxAge) {
        return AGE_PROPERTIES.computeIfAbsent(maxAge, k -> IntegerProperty.create((String)"age", (int)0, (int)maxAge));
    }

    public static IntegerProperty getOrCreateOffset(int min, int max) {
        return DynamicBlockProperties.getOrCreateOffset((Pair<Integer, Integer>)new Pair((Object)min, (Object)max));
    }

    public static IntegerProperty getOrCreateOffset(Pair<Integer, Integer> minMax) {
        return OFFSET_PROPERTIES.computeIfAbsent(minMax, k -> IntegerProperty.create((String)"radius_offset", (int)((Integer)minMax.getA()), (int)((Integer)minMax.getB())));
    }
}

