/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.resource.loading.preparation;

import com.dtteam.dynamictrees.api.resource.DTResource;
import com.dtteam.dynamictrees.api.resource.ResourceCollector;
import com.dtteam.dynamictrees.api.resource.loading.preparation.AbstractResourcePreparer;
import com.dtteam.dynamictrees.api.resource.loading.preparation.PreparationException;
import com.dtteam.dynamictrees.deserialization.JsonHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public final class JsonResourcePreparer
extends AbstractResourcePreparer<JsonElement> {
    private static final String JSON_EXTENSION = ".json";

    public JsonResourcePreparer(String folderName) {
        this(folderName, ResourceCollector.ordered());
    }

    public JsonResourcePreparer(String folderName, ResourceCollector<JsonElement> resourceCollector) {
        super(folderName, JSON_EXTENSION, resourceCollector);
    }

    @Override
    protected void readAndPutResource(Resource resource, ResourceLocation resourceName) throws PreparationException, IOException {
        JsonElement jsonElement = JsonResourcePreparer.readResource(resource);
        this.resourceCollector.put(new DTResource<JsonElement>(resourceName, jsonElement));
    }

    @NotNull
    static JsonElement readResource(Resource resource) throws PreparationException, IOException {
        BufferedReader reader = resource.openAsReader();
        return JsonResourcePreparer.parseJson(reader);
    }

    private static JsonElement parseJson(Reader reader) throws PreparationException {
        try {
            return (JsonElement)GsonHelper.fromJson((Gson)JsonHelper.getGson(), (Reader)reader, JsonElement.class);
        }
        catch (JsonParseException e) {
            throw new PreparationException(e);
        }
    }
}

